"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectedTagListComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _base = require("../base");
var _utils = require("../../utils");
var _common = require("../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/connected/tag_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectTagList = ({
  object,
  tags: allTags,
  onClick,
  tagRender
}) => {
  const objectTags = (0, _react.useMemo)(() => {
    const {
      tags
    } = (0, _common.getObjectTags)(object, allTags);
    tags.sort(_utils.byNameTagSorter);
    return tags;
  }, [object, allTags]);
  return /*#__PURE__*/_react.default.createElement(_base.TagList, {
    tags: objectTags,
    onClick: onClick,
    tagRender: tagRender,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 10
    }
  });
};
const getConnectedTagListComponent = ({
  cache
}) => {
  return props => {
    const tags = (0, _useObservable.default)(cache.getState$(), cache.getState());
    return /*#__PURE__*/_react.default.createElement(SavedObjectTagList, (0, _extends2.default)({}, props, {
      tags: tags,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 12
      }
    }));
  };
};
exports.getConnectedTagListComponent = getConnectedTagListComponent;