"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _utils = require("../../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/base/tag_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createOptionValue = {
  type: '__create_option__'
};
function isTagOption(option) {
  const value = option.value;
  return value.name !== undefined && value.color !== undefined && value.id !== undefined;
}
function isCreateOption(option) {
  const value = option.value;
  return value.type === '__create_option__';
}
const renderCreateOption = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `tagSelectorOption-action__create`,
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    title: _i18n.i18n.translate('xpack.savedObjectsTagging.components.tagSelector.createTagOptionLabel', {
      defaultMessage: 'Create tag'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "tag",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.components.tagSelector.createTagOptionLabel",
    defaultMessage: "Create tag",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }))));
};
const renderTagOption = (option, searchValue, contentClassName) => {
  var _option$value;
  const {
    name,
    color
  } = (_option$value = option.value) !== null && _option$value !== void 0 ? _option$value : {
    name: ''
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": `tagSelectorOption-${(0, _utils.testSubjFriendly)(name)}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: contentClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, name)));
};
const renderOption = (option, searchValue, contentClassName) => {
  if (isCreateOption(option)) {
    return renderCreateOption();
  }
  // just having an if/else block is not enough for TS to infer the type in the else block. strange...
  if (isTagOption(option)) {
    return renderTagOption(option, searchValue, contentClassName);
  }
};
const TagSelector = ({
  tags,
  selected,
  onTagsSelected,
  allowCreate,
  openCreateModal,
  fullWidth = true,
  ...comboBoxProps
}) => {
  const [currentSearch, setCurrentSearch] = (0, _react.useState)('');

  // We are forcing the 'create tag' option to always appear by having its
  // label matching the current search term. This is a workaround to address
  // the 'limitations' of the combobox that does not allow that feature
  // out of the box
  const createTagOption = (0, _react.useMemo)(() => {
    // label and color will never be actually used for rendering.
    // label will only be used to check if the option matches the search,
    // which will always be true because we set its value to the current search.
    // The extra whitespace is required to avoid the combobox to consider that the value
    // is selected when closing the dropdown
    return {
      label: `${currentSearch} `,
      color: '#FFFFFF',
      value: createOptionValue
    };
  }, [currentSearch]);

  // we append the 'create' option if user is allowed to create tags
  const options = (0, _react.useMemo)(() => {
    return [...tags.filter(tag => !tag.managed).map(tag => ({
      label: tag.name,
      color: tag.color,
      value: tag
    })), ...(allowCreate ? [createTagOption] : [])];
  }, [allowCreate, tags, createTagOption]);
  const selectedOptions = (0, _react.useMemo)(() => {
    return options.filter(option => isTagOption(option) && selected.includes(option.value.id));
  }, [selected, options]);
  const onChange = (0, _react.useCallback)(newSelectedOptions => {
    // when clicking on the 'create' option, it is selected.
    // we need to remove it from the selection and then open the
    // create modal instead.
    const tagOptions = newSelectedOptions.filter(isTagOption);
    const selectedIds = tagOptions.map(option => option.value.id);
    onTagsSelected(selectedIds);
    if (newSelectedOptions.find(isCreateOption)) {
      openCreateModal({
        defaultValues: {
          name: currentSearch
        },
        onCreate: tag => {
          onTagsSelected([...selected, tag.id]);
        }
      });
    }
  }, [selected, onTagsSelected, openCreateModal, currentSearch]);
  const {
    onSearchChange: onSearchChangeProp,
    ...restProps
  } = comboBoxProps;
  const handleOnSearchChange = (0, _react.useCallback)(searchValue => {
    setCurrentSearch(searchValue);
    onSearchChangeProp === null || onSearchChangeProp === void 0 ? void 0 : onSearchChangeProp(searchValue);
  }, [onSearchChangeProp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    placeholder: '',
    options: options,
    selectedOptions: selectedOptions,
    onSearchChange: handleOnSearchChange,
    onChange: onChange,
    renderOption: renderOption,
    fullWidth: fullWidth
  }, restProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }));
};
exports.TagSelector = TagSelector;