"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutClass = exports.Flyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _lib = require("../../../lib");
var _overwrite_modal = require("./overwrite_modal");
var _import_mode_control = require("./import_mode_control");
var _import_summary = require("./import_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CREATE_NEW_COPIES_DEFAULT = false;
const OVERWRITE_ALL_DEFAULT = true;
const PAGE_SIZE_OPTIONS = [5, 10, 25];
const getErrorMessage = e => {
  var _e$body, _e$body2;
  const errorMessage = (_e$body = e.body) !== null && _e$body !== void 0 && _e$body.error && (_e$body2 = e.body) !== null && _e$body2 !== void 0 && _e$body2.message ? `${e.body.error}: ${e.body.message}` : e.message;
  return _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.importFileErrorMessage', {
    defaultMessage: 'The file could not be processed due to error: "{error}"',
    values: {
      error: errorMessage
    }
  });
};
class FlyoutClass extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "fetchIndexPatterns", async () => {
      var _await$this$props$dat;
      const indexPatterns = (_await$this$props$dat = await this.props.dataViews.getCache()) === null || _await$this$props$dat === void 0 ? void 0 : _await$this$props$dat.map(savedObject => ({
        id: savedObject.id,
        title: savedObject.attributes.title
      }));
      this.setState({
        indexPatterns
      });
    });
    (0, _defineProperty2.default)(this, "changeImportMode", importMode => {
      this.setState(() => ({
        importMode
      }));
    });
    (0, _defineProperty2.default)(this, "setImportFile", files => {
      if (!files || !files[0]) {
        this.setState({
          file: undefined
        });
        return;
      }
      const file = files[0];
      this.setState({
        file
      });
    });
    /**
     * Import
     *
     * Does the initial import of a file, resolveImportErrors then handles errors and retries
     */
    (0, _defineProperty2.default)(this, "import", async () => {
      const {
        http
      } = this.props;
      const {
        file,
        importMode
      } = this.state;
      if (file === undefined) {
        this.setState({
          status: 'error',
          error: 'missing_file'
        });
        return;
      }
      this.setState({
        status: 'loading',
        error: undefined
      });

      // Import the file
      try {
        const response = await (0, _lib.importFile)(http, file, importMode);
        this.setState((0, _lib.processImportResponse)(response), () => {
          var _this$state$unmatched;
          // Resolve import errors right away if there's no index patterns to match
          // This will ask about overwriting each object, etc
          if (((_this$state$unmatched = this.state.unmatchedReferences) === null || _this$state$unmatched === void 0 ? void 0 : _this$state$unmatched.length) === 0) {
            this.resolveImportErrors();
          }
        });
      } catch (e) {
        this.setState({
          status: 'error',
          error: getErrorMessage(e)
        });
        return;
      }
    });
    /**
     * Get Conflict Resolutions
     *
     * Function iterates through the objects, displays a modal for each asking the user if they wish to overwrite it or not.
     *
     * @param {array} failures List of objects to request the user if they wish to overwrite it
     * @return {Promise<array>} An object with the key being "type:id" and value the resolution chosen by the user
     */
    (0, _defineProperty2.default)(this, "getConflictResolutions", async failures => {
      const resolutions = {};
      for (const conflict of failures) {
        const [overwrite, destinationId] = await new Promise(done => {
          this.setState({
            conflictingRecord: {
              conflict,
              done
            }
          });
        });
        if (overwrite) {
          const {
            type,
            id
          } = conflict.obj;
          resolutions[`${type}:${id}`] = {
            retry: true,
            options: {
              overwrite: true,
              ...(destinationId && {
                destinationId
              })
            }
          };
        }
        this.setState({
          conflictingRecord: undefined
        });
      }
      return resolutions;
    });
    /**
     * Resolve Import Errors
     *
     * Function goes through the failedImports and tries to resolve the issues.
     */
    (0, _defineProperty2.default)(this, "resolveImportErrors", async () => {
      this.setState({
        error: undefined,
        status: 'loading',
        loadingMessage: undefined
      });
      try {
        const updatedState = await (0, _lib.resolveImportErrors)({
          http: this.props.http,
          state: this.state,
          getConflictResolutions: this.getConflictResolutions
        });
        this.setState(updatedState);
      } catch (e) {
        this.setState({
          status: 'error',
          error: getErrorMessage(e)
        });
      }
    });
    (0, _defineProperty2.default)(this, "onIndexChanged", (id, e) => {
      const value = e.target.value;
      this.setState(state => {
        var _state$unmatchedRefer;
        const conflictIndex = (_state$unmatchedRefer = state.unmatchedReferences) === null || _state$unmatchedRefer === void 0 ? void 0 : _state$unmatchedRefer.findIndex(conflict => conflict.existingIndexPatternId === id);
        if (conflictIndex === undefined || conflictIndex === -1) {
          return state;
        }
        return {
          unmatchedReferences: [...state.unmatchedReferences.slice(0, conflictIndex), {
            ...state.unmatchedReferences[conflictIndex],
            newIndexPatternId: value
          }, ...state.unmatchedReferences.slice(conflictIndex + 1)]
        };
      });
    });
    this.state = {
      unmatchedReferences: undefined,
      conflictingRecord: undefined,
      error: undefined,
      file: undefined,
      importCount: 0,
      indexPatterns: undefined,
      importMode: {
        createNewCopies: CREATE_NEW_COPIES_DEFAULT,
        overwrite: OVERWRITE_ALL_DEFAULT
      },
      loadingMessage: undefined,
      status: 'idle'
    };
  }
  componentDidMount() {
    this.fetchIndexPatterns();
  }
  get hasUnmatchedReferences() {
    return this.state.unmatchedReferences && this.state.unmatchedReferences.length > 0;
  }
  get resolutions() {
    return this.state.unmatchedReferences.reduce((accum, {
      existingIndexPatternId,
      newIndexPatternId
    }) => {
      if (newIndexPatternId) {
        accum.push({
          oldId: existingIndexPatternId,
          newId: newIndexPatternId
        });
      }
      return accum;
    }, []);
  }
  renderUnmatchedReferences() {
    const {
      unmatchedReferences
    } = this.state;
    const {
      euiTablePersist: {
        pageSize,
        onTableChange
      }
    } = this.props;
    if (!unmatchedReferences) {
      return null;
    }
    const columns = [{
      field: 'existingIndexPatternId',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnIdName', {
        defaultMessage: 'ID'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnIdDescription', {
        defaultMessage: 'ID of the data view'
      }),
      sortable: true
    }, {
      field: 'list',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnCountName', {
        defaultMessage: 'Count'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnCountDescription', {
        defaultMessage: 'How many affected objects'
      }),
      render: list => {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 312,
            columnNumber: 18
          }
        }, list.length);
      }
    }, {
      field: 'list',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnSampleOfAffectedObjectsName', {
        defaultMessage: 'Sample of affected objects'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnSampleOfAffectedObjectsDescription', {
        defaultMessage: 'Sample of affected objects'
      }),
      render: list => {
        return /*#__PURE__*/_react.default.createElement("ul", {
          css: {
            listStyle: 'none'
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 327,
            columnNumber: 13
          }
        }, (0, _lodash.take)(list, 3).map((obj, key) => /*#__PURE__*/_react.default.createElement("li", {
          key: key,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 329,
            columnNumber: 17
          }
        }, obj.title)));
      }
    }, {
      field: 'existingIndexPatternId',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnNewIndexPatternName', {
        defaultMessage: 'New data view'
      }),
      render: id => {
        var _unmatchedReferences$, _unmatchedReferences$2;
        const options = [{
          text: '-- Skip Import --',
          value: ''
        }, ...this.state.indexPatterns.map(indexPattern => ({
          text: indexPattern.title,
          value: indexPattern.id,
          'data-test-subj': `indexPatternOption-${indexPattern.title}`
        }))];
        const selectedValue = (_unmatchedReferences$ = unmatchedReferences === null || unmatchedReferences === void 0 ? void 0 : (_unmatchedReferences$2 = unmatchedReferences.find(unmatchedRef => unmatchedRef.existingIndexPatternId === id)) === null || _unmatchedReferences$2 === void 0 ? void 0 : _unmatchedReferences$2.newIndexPatternId) !== null && _unmatchedReferences$ !== void 0 ? _unmatchedReferences$ : '';
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
          "aria-label": _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.selectNewIndexPatternAriaLabel', {
            defaultMessage: 'Data view'
          }),
          value: selectedValue,
          "data-test-subj": `managementChangeIndexSelection-${id}`,
          onChange: e => this.onIndexChanged(id, e),
          options: options,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 362,
            columnNumber: 13
          }
        });
      }
    }];
    const pagination = {
      pageSize,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: unmatchedReferences,
      columns: columns,
      pagination: pagination,
      onTableChange: onTableChange,
      tableCaption: _i18n.i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.tableCaption', {
        defaultMessage: 'Conflicting data views'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 7
      }
    });
  }
  renderError() {
    const {
      error,
      status
    } = this.state;
    if (status !== 'error') {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.errorCalloutTitle",
        defaultMessage: "Sorry, there was an error",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 407,
          columnNumber: 13
        }
      }),
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "importSavedObjectsErrorText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 414,
        columnNumber: 11
      }
    }, error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 416,
        columnNumber: 9
      }
    }));
  }
  renderBody() {
    const {
      allowedTypes,
      showPlainSpinner
    } = this.props;
    const {
      status,
      loadingMessage,
      failedImports = [],
      successfulImports = [],
      importMode,
      importWarnings
    } = this.state;
    if (status === 'loading') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceAround",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 434,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 435,
          columnNumber: 11
        }
      }, showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 436,
          columnNumber: 33
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 436,
          columnNumber: 67
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 437,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 438,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 439,
          columnNumber: 15
        }
      }, loadingMessage))));
    }

    // Import summary for completed import
    if (status === 'success') {
      return /*#__PURE__*/_react.default.createElement(_import_summary.ImportSummary, {
        basePath: this.props.http.basePath,
        failedImports: failedImports,
        successfulImports: successfulImports,
        importWarnings: importWarnings !== null && importWarnings !== void 0 ? importWarnings : [],
        allowedTypes: allowedTypes,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 449,
          columnNumber: 9
        }
      });
    }

    // Failed imports
    if (this.hasUnmatchedReferences) {
      return this.renderUnmatchedReferences();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 465,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 469,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 470,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.selectFileToImportFormRowLabel",
        defaultMessage: "Select a file to import",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 471,
          columnNumber: 17
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 466,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      accept: ".ndjson",
      fullWidth: true,
      initialPromptText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.importPromptText",
        defaultMessage: "Import",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 483,
          columnNumber: 15
        }
      }),
      onChange: this.setImportFile,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 479,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 491,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_import_mode_control.ImportModeControl, {
      initialValues: importMode,
      updateSelection: newValues => this.changeImportMode(newValues),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 492,
        columnNumber: 11
      }
    })));
  }
  renderFooter() {
    const {
      status,
      file
    } = this.state;
    const {
      done,
      close
    } = this.props;
    let confirmButton;
    if (status === 'success') {
      confirmButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: done,
        size: "s",
        fill: true,
        "data-test-subj": "importSavedObjectsDoneBtn",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 509,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.importSuccessful.confirmButtonLabel",
        defaultMessage: "Done",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 510,
          columnNumber: 11
        }
      }));
    } else if (this.hasUnmatchedReferences) {
      confirmButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.resolveImportErrors,
        size: "s",
        fill: true,
        isLoading: status === 'loading',
        "data-test-subj": "importSavedObjectsConfirmBtn",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 518,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.importSuccessful.confirmAllChangesButtonLabel",
        defaultMessage: "Confirm all changes",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 525,
          columnNumber: 11
        }
      }));
    } else {
      confirmButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.import,
        size: "s",
        fill: true,
        isDisabled: file === undefined,
        isLoading: status === 'loading',
        "data-test-subj": "importSavedObjectsImportBtn",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 533,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.import.confirmButtonLabel",
        defaultMessage: "Import",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 541,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 550,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 551,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: close,
      size: "s",
      disabled: status === 'loading' || status === 'success',
      "data-test-subj": "importSavedObjectsCancelBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 552,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.flyout.import.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 558,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 564,
        columnNumber: 9
      }
    }, confirmButton));
  }
  renderSubheader() {
    if (this.state.status === 'loading' || this.state.status === 'success') {
      return null;
    }
    let indexPatternConflictsWarning;
    if (this.hasUnmatchedReferences) {
      indexPatternConflictsWarning = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        "data-test-subj": "importSavedObjectsConflictsWarning",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.indexPatternConflictsTitle",
          defaultMessage: "Data Views Conflicts",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 580,
            columnNumber: 13
          }
        }),
        color: "warning",
        iconType: "question",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 577,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 588,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.indexPatternConflictsDescription",
        defaultMessage: "The following saved objects use data views that do not exist. Please select the data views you'd like re-associated with them. You can {indexPatternLink} if necessary.",
        values: {
          indexPatternLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: this.props.newIndexPatternUrl,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 596,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.flyout.indexPatternConflictsCalloutLinkText",
            defaultMessage: "create a new data view",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 597,
              columnNumber: 21
            }
          }))
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 589,
          columnNumber: 13
        }
      })));
    }
    if (!indexPatternConflictsWarning) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 615,
        columnNumber: 7
      }
    }, indexPatternConflictsWarning && /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 617,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 618,
        columnNumber: 13
      }
    }), indexPatternConflictsWarning));
  }
  render() {
    const {
      close,
      allowedTypes
    } = this.props;
    let confirmOverwriteModal;
    const {
      conflictingRecord
    } = this.state;
    if (conflictingRecord) {
      const {
        conflict
      } = conflictingRecord;
      const onFinish = (overwrite, destinationId) => conflictingRecord.done([overwrite, destinationId]);
      confirmOverwriteModal = /*#__PURE__*/_react.default.createElement(_overwrite_modal.OverwriteModal, {
        conflict,
        onFinish,
        allowedTypes,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 635,
          columnNumber: 31
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: close,
      size: "s",
      "data-test-subj": "importSavedObjectsFlyout",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 639,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 640,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 641,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 642,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.flyout.importSavedObjectTitle",
      defaultMessage: "Import saved objects",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 643,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 651,
        columnNumber: 9
      }
    }, this.renderSubheader(), this.renderError(), this.renderBody()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 657,
        columnNumber: 9
      }
    }, this.renderFooter()), confirmOverwriteModal);
  }
}
exports.FlyoutClass = FlyoutClass;
const Flyout = exports.Flyout = (0, _sharedUxTablePersist.withEuiTablePersist)(FlyoutClass, {
  tableId: 'savedObjectsMgmtUnmatchedReferences',
  pageSizeOptions: PAGE_SIZE_OPTIONS,
  initialPageSize: 5
});