"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleDataIngestPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _sample_data_manager = require("./services/sample_data_manager");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SampleDataIngestPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "internalServices", void 0);
    (0, _defineProperty2.default)(this, "isServerlessPlatform", void 0);
    this.context = context;
    this.logger = context.logger.get();
    this.isServerlessPlatform = context.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(coreSetup) {
    const getServices = () => {
      if (!this.internalServices) {
        throw new Error('getServices called before #start');
      }
      return this.internalServices;
    };
    const router = coreSetup.http.createRouter();
    (0, _routes.registerRoutes)({
      router,
      getServices
    });
    return {};
  }
  start() {
    const sampleDataManager = new _sample_data_manager.SampleDataManager({
      kibanaVersion: this.context.env.packageInfo.version,
      artifactsFolder: 'sample-data-artifacts',
      artifactRepositoryUrl: this.context.config.get().artifactRepositoryUrl,
      elserInferenceId: this.context.config.get().elserInferenceId,
      logger: this.logger,
      isServerlessPlatform: this.isServerlessPlatform
    });
    this.internalServices = {
      logger: this.logger,
      sampleDataManager
    };
    return {};
  }
}
exports.SampleDataIngestPlugin = SampleDataIngestPlugin;