"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeFieldForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _constants = require("../../constants");
var _schema = require("./schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/runtime_fields/public/components/runtime_field_form/runtime_field_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createNameNotAllowedValidator = namesNotAllowed => ({
  value
}) => {
  if (namesNotAllowed.includes(value)) {
    return {
      message: _i18n.i18n.translate('xpack.runtimeFields.runtimeFieldsEditor.existRuntimeFieldNamesValidationErrorMessage', {
        defaultMessage: 'There is already a field with this name.'
      })
    };
  }
};

/**
 * Dynamically retrieve the config for the "name" field, adding
 * a validator to avoid duplicated runtime fields to be created.
 *
 * @param namesNotAllowed Array of names not allowed for the field "name"
 * @param defaultValue Initial value of the form
 */
const getNameFieldConfig = (namesNotAllowed, defaultValue) => {
  var _nameFieldConfig$vali;
  const nameFieldConfig = _schema.schema.name;
  if (!namesNotAllowed) {
    return nameFieldConfig;
  }

  // Add validation to not allow duplicates
  return {
    ...nameFieldConfig,
    validations: [...((_nameFieldConfig$vali = nameFieldConfig.validations) !== null && _nameFieldConfig$vali !== void 0 ? _nameFieldConfig$vali : []), {
      validator: createNameNotAllowedValidator(namesNotAllowed.filter(name => name !== (defaultValue === null || defaultValue === void 0 ? void 0 : defaultValue.name)))
    }]
  };
};
const mapReturnTypeToPainlessContext = runtimeType => {
  switch (runtimeType) {
    case 'keyword':
      return 'string_script_field_script_field';
    case 'long':
      return 'long_script_field_script_field';
    case 'double':
      return 'double_script_field_script_field';
    case 'date':
      return 'date_script_field';
    case 'ip':
      return 'ip_script_field_script_field';
    case 'boolean':
      return 'boolean_script_field_script_field';
    default:
      return 'string_script_field_script_field';
  }
};
const RuntimeFieldFormComp = ({
  defaultValue,
  onChange,
  links,
  ctx: {
    namesNotAllowed,
    existingConcreteFields = []
  } = {}
}) => {
  const typeFieldConfig = _schema.schema.type;
  const [painlessContext, setPainlessContext] = (0, _react.useState)(mapReturnTypeToPainlessContext(typeFieldConfig.defaultValue));
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue,
    schema: _schema.schema
  });
  const {
    submit,
    isValid: isFormValid,
    isSubmitted
  } = form;
  const [{
    name
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: 'name'
  });
  const nameFieldConfig = getNameFieldConfig(namesNotAllowed, defaultValue);
  const onTypeChange = (0, _react.useCallback)(newType => {
    setPainlessContext(mapReturnTypeToPainlessContext(newType[0].value));
  }, []);
  const suggestionProvider = _monaco.PainlessLang.getSuggestionProvider(painlessContext, existingConcreteFields);
  (0, _react.useEffect)(() => {
    if (onChange) {
      onChange({
        isValid: isFormValid,
        isSubmitted,
        submit
      });
    }
  }, [onChange, isFormValid, isSubmitted, submit]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    className: "runtimeFieldEditor_form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "name",
    config: nameFieldConfig,
    component: _shared_imports.TextField,
    "data-test-subj": "nameField",
    componentProps: {
      euiFieldProps: {
        'aria-label': _i18n.i18n.translate('xpack.runtimeFields.form.nameAriaLabel', {
          defaultMessage: 'Name field'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "type",
    onChange: onTypeChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, ({
    label,
    value,
    setValue
  }) => {
    if (value === undefined) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.runtimeFields.form.runtimeType.placeholderLabel', {
        defaultMessage: 'Select a type'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: _constants.RUNTIME_FIELD_OPTIONS,
      selectedOptions: value,
      onChange: newValue => {
        if (newValue.length === 0) {
          // Don't allow clearing the type. One must always be selected
          return;
        }
        setValue(newValue);
      },
      isClearable: false,
      "data-test-subj": "typeField",
      "aria-label": _i18n.i18n.translate('xpack.runtimeFields.form.typeSelectAriaLabel', {
        defaultMessage: 'Type select'
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 21
      }
    })));
  }))), existingConcreteFields.find(field => field.name === name) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.runtimeFields.form.fieldShadowingCalloutTitle', {
      defaultMessage: 'Field shadowing'
    }),
    color: "warning",
    iconType: "pin",
    size: "s",
    "data-test-subj": "shadowingFieldCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.runtimeFields.form.fieldShadowingCalloutDescription', {
    defaultMessage: 'This field shares the name of a mapped field. Values for this field will be returned in search results.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "script.source",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 7
    }
  }, ({
    value,
    setValue,
    label,
    isValid,
    getErrorsMessages
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      error: getErrorsMessages(),
      isInvalid: !isValid,
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.runtimeFields.form.source.scriptFieldHelpText",
        defaultMessage: "Runtime fields without a script retrieve values from a field with the same name in {source}. If a field with the same name doesn\u2019t exist, no values return when a search request includes the runtime field. {learnMoreLink}",
        values: {
          learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: links.runtimePainless,
            target: "_blank",
            external: true,
            "data-test-subj": "painlessSyntaxLearnMoreLink",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 264,
              columnNumber: 23
            }
          }, _i18n.i18n.translate('xpack.runtimeFields.form.script.learnMoreLinkText', {
            defaultMessage: 'Learn about script syntax.'
          })),
          source: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 275,
              columnNumber: 29
            }
          }, '_source')
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 17
        }
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.CodeEditor, {
      languageId: _monaco.PainlessLang.ID,
      suggestionProvider: suggestionProvider,
      width: "100%",
      height: "300px",
      value: value,
      onChange: setValue,
      options: {
        fontSize: 12,
        minimap: {
          enabled: false
        },
        scrollBeyondLastLine: false,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        automaticLayout: true,
        suggest: {
          snippetsPreventQuickSuggestions: false
        }
      },
      "data-test-subj": "scriptField",
      "aria-label": _i18n.i18n.translate('xpack.runtimeFields.form.scriptEditorAriaLabel', {
        defaultMessage: 'Script editor'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 15
      }
    }));
  }));
};
const RuntimeFieldForm = exports.RuntimeFieldForm = /*#__PURE__*/_react.default.memo(RuntimeFieldFormComp);