"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldChooser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps/components/field_chooser.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FieldChooser extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onSearch", e => {
      this.setState({
        searchValue: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(state => ({
        isOpen: !state.isOpen
      }));
    });
    (0, _defineProperty2.default)(this, "close", () => {
      this.setState({
        isOpen: false
      });
    });
    this.state = {
      isOpen: false,
      searchValue: ''
    };
  }
  render() {
    const {
      buttonLabel,
      columns,
      fields,
      selectedFields,
      prompt,
      onSelectField,
      dataTestSubj
    } = this.props;
    const {
      isOpen,
      searchValue
    } = this.state;
    const getRowProps = item => {
      return {
        onClick: () => {
          onSelectField(item);
        }
      };
    };
    const renderFlyout = () => {
      // Derive the fields which the user can select.
      const selectedFieldNames = selectedFields.map(({
        name
      }) => name);
      const unselectedFields = fields.filter(({
        name
      }) => {
        return !selectedFieldNames.includes(name);
      });
      const searchedItems = searchValue ? unselectedFields.filter(item => {
        const normalizedSearchValue = searchValue.trim().toLowerCase();
        return item.name.toLowerCase().includes(normalizedSearchValue) || item.type.toLowerCase().includes(normalizedSearchValue);
      }) : unselectedFields;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        onClose: this.close,
        "aria-labelledby": "fieldChooserFlyoutTitle",
        size: "m",
        maxWidth: 400,
        "data-test-subj": dataTestSubj,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "m",
        id: "fieldChooserFlyoutTitle",
        "data-test-subj": "rollupJobCreateFlyoutTitle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 15
        }
      }, buttonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
        placeholder: prompt,
        value: searchValue,
        onChange: this.onSearch,
        "aria-label": prompt,
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
        items: searchedItems,
        columns: columns,
        rowProps: getRowProps,
        responsive: false,
        "data-test-subj": `${dataTestSubj}-table`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 13
        }
      })));
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.onButtonClick,
      "data-test-subj": "rollupJobShowFieldChooserButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, buttonLabel), isOpen ? renderFlyout() : null);
  }
}
exports.FieldChooser = FieldChooser;
(0, _defineProperty2.default)(FieldChooser, "propTypes", {
  buttonLabel: _propTypes.default.node.isRequired,
  columns: _propTypes.default.array.isRequired,
  fields: _propTypes.default.array.isRequired,
  selectedFields: _propTypes.default.array.isRequired,
  onSelectField: _propTypes.default.func.isRequired,
  prompt: _propTypes.default.string,
  dataTestSubj: _propTypes.default.string
});
(0, _defineProperty2.default)(FieldChooser, "defaultProps", {
  prompt: 'Search',
  dataTestSubj: 'rollupJobFieldChooser'
});