"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transactionDurationParamsSchema = exports.AggregationType = void 0;
var _configSchema = require("@kbn/config-schema");
var _search_configuration_schema = require("../common/search_configuration_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let AggregationType = exports.AggregationType = /*#__PURE__*/function (AggregationType) {
  AggregationType["Avg"] = "avg";
  AggregationType["P95"] = "95th";
  AggregationType["P99"] = "99th";
  return AggregationType;
}({});
const transactionDurationParamsSchema = exports.transactionDurationParamsSchema = _configSchema.schema.object({
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Filter the rule to apply to a specific service.'
    }
  })),
  transactionType: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Filter the rule to apply to a specific transaction type.'
    }
  })),
  transactionName: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Filter the rule to apply to a specific transaction name.'
    }
  })),
  windowSize: _configSchema.schema.number({
    meta: {
      description: 'The size of the time window (in `windowUnit` units), which determines how far back to search for documents. Generally it should be a value higher than the rule check interval to avoid gaps in detection.'
    }
  }),
  windowUnit: _configSchema.schema.string({
    meta: {
      description: 'The type of units for the time window. For example: minutes, hours, or days.'
    }
  }),
  threshold: _configSchema.schema.number({
    meta: {
      description: 'The latency threshold value.'
    }
  }),
  aggregationType: _configSchema.schema.oneOf([_configSchema.schema.literal(AggregationType.Avg), _configSchema.schema.literal(AggregationType.P95), _configSchema.schema.literal(AggregationType.P99)], {
    meta: {
      description: 'The type of aggregation to perform.'
    }
  }),
  environment: _configSchema.schema.string({
    meta: {
      description: 'Filter the rule to apply to a specific environment.'
    }
  }),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'Perform a composite aggregation against the selected fields. When any of these groups match the selected rule conditions, an alert is triggered per group.'
    }
  }))),
  useKqlFilter: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'A Kibana Query Language (KQL) expression thats limits the scope of alerts.'
    }
  })),
  searchConfiguration: _configSchema.schema.maybe(_search_configuration_schema.searchConfigurationSchema)
});