"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawScheduledReportSchema = exports.rawNotificationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/task-manager-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rawLayoutIdSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('preserve_layout'), _configSchema.schema.literal('print'), _configSchema.schema.literal('canvas')]);
const rawNotificationSchema = exports.rawNotificationSchema = _configSchema.schema.object({
  email: _configSchema.schema.maybe(_configSchema.schema.object({
    to: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    bcc: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    cc: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }, {
    validate: value => {
      const allEmails = new Set([...(value.to || []), ...(value.bcc || []), ...(value.cc || [])]);
      if (allEmails.size === 0) {
        return 'At least one email address is required';
      }
    }
  }))
});
const rawScheduledReportSchema = exports.rawScheduledReportSchema = _configSchema.schema.object({
  createdAt: _configSchema.schema.string(),
  createdBy: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  jobType: _configSchema.schema.string(),
  meta: _configSchema.schema.object({
    isDeprecated: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    layout: _configSchema.schema.maybe(rawLayoutIdSchema),
    objectType: _configSchema.schema.string()
  }),
  migrationVersion: _configSchema.schema.maybe(_configSchema.schema.string()),
  notification: _configSchema.schema.maybe(rawNotificationSchema),
  payload: _configSchema.schema.string(),
  schedule: _server.scheduleRruleSchemaV1,
  title: _configSchema.schema.string()
});