"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmailsValidator = void 0;
var _common = require("@kbn/actions-plugin/common");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmailsValidator = validateEmailAddresses => ({
  value,
  path
}) => {
  const validatedEmails = validateEmailAddresses(Array.isArray(value) ? value : [value]);
  for (const validatedEmail of validatedEmails) {
    if (!validatedEmail.valid) {
      return {
        path,
        message: validatedEmail.reason === _common.InvalidEmailReason.notAllowed ? (0, _translations.getNotAllowedEmailAddress)(value) : (0, _translations.getInvalidEmailAddress)(value)
      };
    }
  }
};
exports.getEmailsValidator = getEmailsValidator;