"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterWizard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../components");
var _remote_cluster_review = require("../components/remote_cluster_config_steps/remote_cluster_review");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/remote_cluster_add/wizard_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SETUP_TRUST = 1;
const CONFIGURE_CONNECTION = 2;
const REVIEW = 3;
const FORM_MAX_WIDTH = 850;
const RemoteClusterWizard = ({
  saveRemoteClusterConfig,
  onCancel,
  isSaving,
  addClusterError
}) => {
  const [formState, setFormState] = (0, _react.useState)();
  const [formHasErrors, setFormHasErrors] = (0, _react.useState)(false);
  const [currentStep, setCurrentStep] = (0, _react.useState)(SETUP_TRUST);
  const [securityModel, setSecurityModel] = (0, _react.useState)('');
  const stepDefinitions = (0, _react.useMemo)(() => [{
    step: SETUP_TRUST,
    title: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.selectConnectionTypeLabel', {
      defaultMessage: 'Select connection type'
    }),
    status: currentStep === SETUP_TRUST ? 'current' : 'complete',
    onClick: () => setCurrentStep(SETUP_TRUST)
  }, {
    step: CONFIGURE_CONNECTION,
    title: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.addConnectionInfoLabel', {
      defaultMessage: 'Add connection information'
    }),
    disabled: !securityModel,
    status: currentStep === CONFIGURE_CONNECTION ? 'current' : 'complete',
    onClick: () => setCurrentStep(CONFIGURE_CONNECTION)
  }, {
    step: REVIEW,
    title: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.confirmSetup', {
      defaultMessage: 'Confirm setup'
    }),
    disabled: !formState || formHasErrors,
    status: currentStep === REVIEW ? 'current' : 'incomplete',
    onClick: () => setCurrentStep(REVIEW)
  }], [currentStep, formHasErrors, formState, securityModel]);
  const completeTrustStep = model => {
    setSecurityModel(model);
    setCurrentStep(CONFIGURE_CONNECTION);
  };
  const onSecurityUpdate = model => {
    if (securityModel !== '') {
      setSecurityModel(model);
    }
  };

  // Upon finalizing configuring the connection, we need to temporarily store the
  // cluster configuration so that we can persist it when the user completes the
  // trust step.
  const completeConfigStep = clusterConfig => {
    setFormState(clusterConfig);
    setCurrentStep(REVIEW);
  };
  const onConfigUpdate = (clusterConfig, hasErrors) => {
    if (formState !== undefined) {
      setFormState(clusterConfig);
      setFormHasErrors(hasErrors);
    }
  };
  const completeReviewStep = () => {
    saveRemoteClusterConfig(formState);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: FORM_MAX_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: stepDefinitions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), currentStep === SETUP_TRUST && /*#__PURE__*/_react.default.createElement(_components.RemoteClusterSetupTrust, {
    next: completeTrustStep,
    currentSecurityModel: securityModel,
    onSecurityChange: onSecurityUpdate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: currentStep === CONFIGURE_CONNECTION ? 'block' : 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.RemoteClusterForm, {
    confirmFormAction: completeConfigStep,
    onBack: () => setCurrentStep(SETUP_TRUST),
    onConfigChange: onConfigUpdate,
    confirmFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.nextButtonLabel",
      defaultMessage: "Next",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }),
    backFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.backButtonLabel",
      defaultMessage: "Back",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: currentStep === REVIEW ? 'block' : 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, formState && /*#__PURE__*/_react.default.createElement(_remote_cluster_review.RemoteClusterReview, {
    onBack: () => setCurrentStep(CONFIGURE_CONNECTION),
    isSaving: isSaving,
    saveError: addClusterError,
    onSubmit: completeReviewStep,
    cluster: formState,
    securityModel: securityModel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })));
};
exports.RemoteClusterWizard = RemoteClusterWizard;