"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDailyDataGenerationSize = getDailyDataGenerationSize;
exports.getEstimatedSizeForDocumentsInIndex = getEstimatedSizeForDocumentsInIndex;
var _server = require("@kbn/observability-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEstimatedSizeForDocumentsInIndex({
  allIndicesStats,
  indexName,
  numberOfDocs
}) {
  var _indexStats$total$sto, _indexStats$total, _indexStats$total$sto2, _indexStats$total2, _indexStats$total2$do;
  const indexStats = allIndicesStats[indexName];
  const indexTotalSize = (_indexStats$total$sto = indexStats === null || indexStats === void 0 ? void 0 : (_indexStats$total = indexStats.total) === null || _indexStats$total === void 0 ? void 0 : (_indexStats$total$sto2 = _indexStats$total.store) === null || _indexStats$total$sto2 === void 0 ? void 0 : _indexStats$total$sto2.size_in_bytes) !== null && _indexStats$total$sto !== void 0 ? _indexStats$total$sto : 0;
  const indexTotalDocCount = indexStats === null || indexStats === void 0 ? void 0 : (_indexStats$total2 = indexStats.total) === null || _indexStats$total2 === void 0 ? void 0 : (_indexStats$total2$do = _indexStats$total2.docs) === null || _indexStats$total2$do === void 0 ? void 0 : _indexStats$total2$do.count;
  const estimatedSize = indexTotalDocCount ? numberOfDocs / indexTotalDocCount * indexTotalSize : 0;
  return estimatedSize;
}
async function getDailyDataGenerationSize({
  client,
  timeFrom,
  timeTo,
  allIndicesStats,
  kuery
}) {
  var _response$aggregation, _response$aggregation2;
  const response = await client.search('profiling_indices_size', {
    index: ['profiling-events-*', 'profiling-stacktraces', 'profiling-hosts', 'profiling-metrics'].join(),
    query: {
      bool: {
        filter: {
          ...(0, _server.kqlQuery)(kuery),
          range: {
            '@timestamp': {
              gte: String(timeFrom),
              lt: String(timeTo),
              format: 'epoch_second'
            }
          }
        }
      }
    },
    aggs: {
      indices: {
        terms: {
          field: '_index'
        },
        aggs: {
          number_of_documents: {
            value_count: {
              field: '_index'
            }
          }
        }
      }
    }
  });
  const estimatedIncrementalSize = allIndicesStats ? (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.indices.buckets.reduce((prev, curr) => {
    return prev + getEstimatedSizeForDocumentsInIndex({
      allIndicesStats,
      indexName: curr.key,
      numberOfDocs: curr.number_of_documents.value
    });
  }, 0)) !== null && _response$aggregation !== void 0 ? _response$aggregation : 0 : 0;
  const durationAsDays = (timeTo - timeFrom) / 60 / 60 / 24;
  return {
    dailyDataGenerationBytes: estimatedIncrementalSize / durationAsDays
  };
}