"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupedIndexDetailsChart = GroupedIndexDetailsChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_profiling_charts_theme = require("../../../hooks/use_profiling_charts_theme");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/profiling/public/views/storage_explorer/data_breakdown/grouped_index_details_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GroupedIndexDetailsChart({
  data = []
}) {
  const theme = (0, _eui.useEuiTheme)();
  const {
    chartsBaseTheme,
    chartsTheme
  } = (0, _use_profiling_charts_theme.useProfilingChartsTheme)();
  const groupedPalette = (0, _eui.euiPaletteColorBlind)();
  const sunburstData = data.map(item => {
    const {
      indexName,
      ...values
    } = item;
    return {
      key: (0, _utils.getGroupedIndexLabel)(item.indexName),
      ...values
    };
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      backgroundColor: theme.euiTheme.colors.lightestShade,
      height: '100%',
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, sunburstData.length ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 250,
      width: 400
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: true,
    legendPosition: _charts.Position.Right,
    baseTheme: chartsBaseTheme,
    theme: {
      ...chartsTheme,
      background: {
        color: 'transparent'
      }
    },
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    layout: "sunburst",
    id: "spec_1",
    data: sunburstData,
    valueAccessor: d => Number(d.sizeInBytes),
    valueGetter: "percent",
    valueFormatter: value => (0, _common.asDynamicBytes)(value),
    layers: [{
      groupByRollup: d => d.key,
      shape: {
        fillColor: (_, sortIndex) => groupedPalette[sortIndex]
      }
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: 250,
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.profiling.storageExplorer.dataBreakdown.noDataToDisplay', {
    defaultMessage: 'No data to display'
  }))));
}