"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionsView = FunctionsView;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _profilingUtils = require("@kbn/profiling-utils");
var _normalization_menu = require("../../components/normalization_menu");
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _redirect_to = require("../../components/redirect_to");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/profiling/public/views/functions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FunctionsView({
  children
}) {
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/functions/*');
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  if (routePath === '/functions') {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      pathname: "/functions/topn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 12
      }
    });
  }
  const isDifferentialView = routePath === '/functions/differential';
  const tabs = [{
    label: _i18n.i18n.translate('xpack.profiling.functionsView.functionsTabLabel', {
      defaultMessage: 'TopN functions'
    }),
    isSelected: !isDifferentialView,
    href: profilingRouter.link('/functions/topn', {
      query
    })
  }, {
    label: _i18n.i18n.translate('xpack.profiling.functionsView.differentialFunctionsTabLabel', {
      defaultMessage: 'Differential TopN functions'
    }),
    isSelected: isDifferentialView,
    href: profilingRouter.link('/functions/differential', {
      query: {
        ...query,
        comparisonRangeFrom: query.rangeFrom,
        comparisonRangeTo: query.rangeTo,
        comparisonKuery: query.kuery,
        normalizationMode: 'normalizationMode' in query ? query.normalizationMode : _normalization_menu.NormalizationMode.Time,
        comparisonSortField: 'comparisonSortField' in query ? query.comparisonSortField : _profilingUtils.TopNComparisonFunctionSortField.ComparisonRank,
        comparisonSortDirection: 'comparisonSortDirection' in query ? query.comparisonSortDirection : 'asc'
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: tabs,
    hideSearchBar: isDifferentialView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, children);
}