"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrimaryAndComparisonSearchBar = PrimaryAndComparisonSearchBar;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_profiling_params = require("../hooks/use_profiling_params");
var _use_profiling_router = require("../hooks/use_profiling_router");
var _use_profiling_route_path = require("../hooks/use_profiling_route_path");
var _use_time_range_context = require("../hooks/use_time_range_context");
var _primary_profiling_search_bar = require("./profiling_app_page_template/primary_profiling_search_bar");
var _profiling_search_bar = require("./profiling_app_page_template/profiling_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/profiling/public/components/primary_and_comparison_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function PrimaryAndComparisonSearchBar() {
  const {
    path,
    query,
    query: {
      comparisonKuery,
      comparisonRangeFrom,
      comparisonRangeTo
    }
  } = (0, _use_profiling_params.useAnyOfProfilingParams)('/flamegraphs/differential', '/functions/differential');
  const {
    refresh
  } = (0, _use_time_range_context.useTimeRangeContext)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  function navigate(nextOptions) {
    if (routePath === '/flamegraphs/differential') {
      var _nextOptions$kuery;
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          comparisonRangeFrom: nextOptions.rangeFrom,
          comparisonRangeTo: nextOptions.rangeTo,
          comparisonKuery: (_nextOptions$kuery = nextOptions.kuery) !== null && _nextOptions$kuery !== void 0 ? _nextOptions$kuery : query.comparisonKuery
        }
      });
    } else {
      var _nextOptions$kuery2;
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          comparisonRangeFrom: nextOptions.rangeFrom,
          comparisonRangeTo: nextOptions.rangeTo,
          comparisonKuery: (_nextOptions$kuery2 = nextOptions.kuery) !== null && _nextOptions$kuery2 !== void 0 ? _nextOptions$kuery2 : query.comparisonKuery
        }
      });
    }
  }
  let baselineTitle;
  let comparisonTitle;
  if (routePath === '/flamegraphs/differential') {
    baselineTitle = _i18n.i18n.translate('xpack.profiling.comparisonSearch.baselineTitleFlamegraph', {
      defaultMessage: 'Baseline flamegraph'
    });
    comparisonTitle = _i18n.i18n.translate('xpack.profiling.comparisonSearch.comparisonTitleFlamegraph', {
      defaultMessage: 'Comparison flamegraph'
    });
  } else {
    baselineTitle = _i18n.i18n.translate('xpack.profiling.comparisonSearch.baselineTitleFunctions', {
      defaultMessage: 'Baseline functions'
    });
    comparisonTitle = _i18n.i18n.translate('xpack.profiling.comparisonSearch.comparisonTitleFunctions', {
      defaultMessage: 'Comparison functions'
    });
  }
  const swapSides = _i18n.i18n.translate('xpack.profiling.comparisonSearch.swapSides', {
    defaultMessage: 'Swap sides'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    alignItems: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, baselineTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_primary_profiling_search_bar.PrimaryProfilingSearchBar, {
    showSubmitButton: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      padding: '0 8px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: swapSides,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "profilingPrimaryAndComparisonSearchBarButton",
    iconType: "merge",
    size: "m",
    "aria-label": swapSides,
    onClick: () => {
      const next = {
        ...query,
        rangeFrom: comparisonRangeFrom,
        rangeTo: comparisonRangeTo,
        kuery: comparisonKuery,
        comparisonRangeFrom: query.rangeFrom,
        comparisonRangeTo: query.rangeTo,
        comparisonKuery: query.kuery
      };
      if (routePath === '/flamegraphs/differential') {
        profilingRouter.push(routePath, {
          path,
          query: next
        });
      } else {
        profilingRouter.push(routePath, {
          path,
          query: next
        });
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, comparisonTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_profiling_search_bar.ProfilingSearchBar, {
    kuery: comparisonKuery,
    rangeFrom: comparisonRangeFrom,
    rangeTo: comparisonRangeTo,
    showSubmitButton: false,
    onQuerySubmit: next => {
      var _next$query;
      navigate({
        kuery: String(((_next$query = next.query) === null || _next$query === void 0 ? void 0 : _next$query.query) || ''),
        rangeFrom: next.dateRange.from,
        rangeTo: next.dateRange.to
      });
    },
    onRefresh: nextDateRange => {
      navigate({
        rangeFrom: nextDateRange.dateRange.from,
        rangeTo: nextDateRange.dateRange.to
      });
    },
    onRefreshClick: () => {
      refresh();
    },
    dataTestSubj: "profilingComparisonUnifiedSearchBar",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  })));
}