"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openZipArchive = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _yauzl = _interopRequireDefault(require("yauzl"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const openZipArchive = async archivePath => {
  return new Promise((resolve, reject) => {
    const entries = [];
    _yauzl.default.open(archivePath, {
      lazyEntries: true,
      autoClose: false
    }, (err, zipFile) => {
      if (err || !zipFile) {
        return reject(err !== null && err !== void 0 ? err : 'No zip file');
      }
      zipFile.on('entry', entry => {
        entries.push(entry);
        zipFile.readEntry();
      });
      zipFile.on('end', () => {
        const archive = new ZipArchiveImpl(entries, zipFile);
        resolve(archive);
      });
      zipFile.on('close', () => {});
      zipFile.readEntry();
    });
  });
};
exports.openZipArchive = openZipArchive;
class ZipArchiveImpl {
  constructor(entries, zipFile) {
    (0, _defineProperty2.default)(this, "zipFile", void 0);
    (0, _defineProperty2.default)(this, "entries", void 0);
    this.zipFile = zipFile;
    this.entries = new Map(entries.map(entry => [entry.fileName, entry]));
  }
  hasEntry(entryPath) {
    return this.entries.has(entryPath);
  }
  getEntryPaths() {
    return [...this.entries.keys()];
  }
  getEntryContent(entryPath) {
    const foundEntry = this.entries.get(entryPath);
    if (!foundEntry) {
      throw new Error(`Entry ${entryPath} not found in archive`);
    }
    return getZipEntryContent(this.zipFile, foundEntry);
  }
  close() {
    this.zipFile.close();
  }
}
const getZipEntryContent = async (zipFile, entry) => {
  return new Promise((resolve, reject) => {
    zipFile.openReadStream(entry, (err, readStream) => {
      if (err) {
        return reject(err);
      } else {
        const chunks = [];
        readStream.on('data', chunk => {
          chunks.push(chunk);
        });
        readStream.on('end', () => {
          resolve(Buffer.concat(chunks));
        });
        readStream.on('error', () => {
          reject();
        });
      }
    });
  });
};