"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS", {
  enumerable: true,
  get: function () {
    return _components.DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS;
  }
});
Object.defineProperty(exports, "DashboardDrilldownOptionsComponent", {
  enumerable: true,
  get: function () {
    return _components.DashboardDrilldownOptionsComponent;
  }
});
Object.defineProperty(exports, "LazyDashboardPicker", {
  enumerable: true,
  get: function () {
    return _components.LazyDashboardPicker;
  }
});
Object.defineProperty(exports, "LazyDataViewPicker", {
  enumerable: true,
  get: function () {
    return _components.LazyDataViewPicker;
  }
});
Object.defineProperty(exports, "LazyExpressionInput", {
  enumerable: true,
  get: function () {
    return _components.LazyExpressionInput;
  }
});
Object.defineProperty(exports, "LazyFieldPicker", {
  enumerable: true,
  get: function () {
    return _components.LazyFieldPicker;
  }
});
Object.defineProperty(exports, "LazyLabsBeakerButton", {
  enumerable: true,
  get: function () {
    return _components.LazyLabsBeakerButton;
  }
});
Object.defineProperty(exports, "LazyLabsFlyout", {
  enumerable: true,
  get: function () {
    return _components.LazyLabsFlyout;
  }
});
Object.defineProperty(exports, "LazySavedObjectSaveModalDashboard", {
  enumerable: true,
  get: function () {
    return _components.LazySavedObjectSaveModalDashboard;
  }
});
Object.defineProperty(exports, "LazySavedObjectSaveModalDashboardWithSaveResult", {
  enumerable: true,
  get: function () {
    return _components.LazySavedObjectSaveModalDashboardWithSaveResult;
  }
});
Object.defineProperty(exports, "PanelPlacementStrategy", {
  enumerable: true,
  get: function () {
    return _panel_placement.PanelPlacementStrategy;
  }
});
exports.plugin = plugin;
exports.registerExpressionsLanguage = void 0;
Object.defineProperty(exports, "withSuspense", {
  enumerable: true,
  get: function () {
    return _components.withSuspense;
  }
});
var _plugin = require("./plugin");
var _components = require("./components");
var _panel_placement = require("./registries/panel_placement");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Register a set of Expression Functions with the Presentation Utility ExpressionInput.  This allows
 * the Monaco Editor to understand the functions and their arguments.
 *
 * This function is async in order to move the logic to an async chunk.
 *
 * @param expressionFunctions A set of Expression Functions to use in the ExpressionInput.
 */
const registerExpressionsLanguage = async expressionFunctions => {
  const languages = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/expression_input/language')));
  return languages.registerExpressionsLanguage(expressionFunctions);
};
exports.registerExpressionsLanguage = registerExpressionsLanguage;
function plugin() {
  return new _plugin.PresentationUtilPlugin();
}