"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelErrorInternal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _searchErrors = require("@kbn/search-errors");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _kibana_services = require("../kibana_services");
var _execute_edit_action = require("../panel_actions/edit_panel_action/execute_edit_action");
var _constants = require("../panel_actions/edit_panel_action/constants");
var _panel_actions = require("../panel_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/presentation_panel/public/panel_component/presentation_panel_error_internal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PresentationPanelErrorInternal = ({
  api,
  error
}) => {
  var _api$title$, _searchErrorDisplay$a, _searchErrorDisplay$b, _error$message;
  const errorTextStyle = (0, _reactHooks.useErrorTextStyle)();
  const [isEditable, setIsEditable] = (0, _react.useState)(false);
  const handleErrorClick = (0, _react.useMemo)(() => isEditable ? () => (0, _execute_edit_action.executeEditPanelAction)(api) : undefined, [api, isEditable]);
  const [label, setLabel] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (!isEditable) {
      setLabel('');
      return;
    }
    const canceled = false;
    _kibana_services.uiActions.getAction(_constants.ACTION_EDIT_PANEL).then(action => {
      if (canceled) return;
      setLabel(action === null || action === void 0 ? void 0 : action.getDisplayName({
        embeddable: api,
        trigger: {
          id: _panel_actions.CONTEXT_MENU_TRIGGER
        }
      }));
    }).catch(() => {
      // ignore action not found
    });
  }, [api, isEditable]);
  const panelTitle = (0, _presentationPublishing.useStateFromPublishingSubject)((_api$title$ = api === null || api === void 0 ? void 0 : api.title$) !== null && _api$title$ !== void 0 ? _api$title$ : new _rxjs.BehaviorSubject(undefined));
  const ariaLabel = (0, _react.useMemo)(() => panelTitle ? _i18n.i18n.translate('presentationPanel.error.editButton', {
    defaultMessage: 'Edit {value}',
    values: {
      value: panelTitle
    }
  }) : label, [label, panelTitle]);

  // Get initial editable state from action and subscribe to changes.
  (0, _react.useEffect)(() => {
    let canceled = false;
    const subscription = new _rxjs.Subscription();
    (async (_editPanelAction$coul, _editPanelAction$getC, _editPanelAction$getC2) => {
      const editPanelAction = await _kibana_services.uiActions.getAction(_constants.ACTION_EDIT_PANEL);
      const context = {
        embeddable: api,
        trigger: {
          id: _panel_actions.CONTEXT_MENU_TRIGGER
        }
      };
      if (canceled || !(editPanelAction !== null && editPanelAction !== void 0 && (_editPanelAction$coul = editPanelAction.couldBecomeCompatible) !== null && _editPanelAction$coul !== void 0 && _editPanelAction$coul.call(editPanelAction, context))) return;
      const initiallyCompatible = await (editPanelAction === null || editPanelAction === void 0 ? void 0 : editPanelAction.isCompatible(context));
      if (canceled) return;
      setIsEditable(initiallyCompatible);
      const compatibilitySubscription = editPanelAction === null || editPanelAction === void 0 ? void 0 : (_editPanelAction$getC = editPanelAction.getCompatibilityChangesSubject) === null || _editPanelAction$getC === void 0 ? void 0 : (_editPanelAction$getC2 = _editPanelAction$getC.call(editPanelAction, context)) === null || _editPanelAction$getC2 === void 0 ? void 0 : _editPanelAction$getC2.pipe((0, _rxjs.switchMap)(async () => {
        return await editPanelAction.isCompatible(context);
      })).subscribe(async isCompatible => {
        if (!canceled) setIsEditable(isCompatible);
      });
      subscription.add(compatibilitySubscription);
    })();
    return () => {
      canceled = true;
      subscription.unsubscribe();
    };
  }, [api]);
  const searchErrorDisplay = (0, _searchErrors.renderSearchError)(error);
  const actions = (_searchErrorDisplay$a = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.actions) !== null && _searchErrorDisplay$a !== void 0 ? _searchErrorDisplay$a : [];
  if (isEditable) {
    actions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": ariaLabel,
      onClick: handleErrorClick,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 7
      }
    }, label));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: (_searchErrorDisplay$b = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.body) !== null && _searchErrorDisplay$b !== void 0 ? _searchErrorDisplay$b : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: errorTextStyle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
      "data-test-subj": "errorMessageMarkdown",
      readOnly: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }, (_error$message = error.message) !== null && _error$message !== void 0 && _error$message.length ? error.message : _i18n.i18n.translate('presentationPanel.emptyErrorMessage', {
      defaultMessage: 'Error'
    }))),
    "data-test-subj": "embeddableStackError",
    iconType: "warning",
    iconColor: "danger",
    layout: "vertical",
    actions: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  });
};
exports.PresentationPanelErrorInternal = PresentationPanelErrorInternal;