"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsTableField = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _agents_table = require("../../agents/agents_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/osquery/public/live_queries/form/agents_table_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const checkAgentsLength = agentsSelection => {
  if (!(0, _lodash.isEmpty)(agentsSelection)) {
    var _agentsSelection$agen, _agentsSelection$plat, _agentsSelection$poli;
    if (agentsSelection.offlineAgentsSelected) {
      return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.osqueryAgentsOfflineErrorMessage', {
        defaultMessage: 'Some agents are offline'
      });
    }
    const isValid = !!(agentsSelection.allAgentsSelected || (_agentsSelection$agen = agentsSelection.agents) !== null && _agentsSelection$agen !== void 0 && _agentsSelection$agen.length || (_agentsSelection$plat = agentsSelection.platformsSelected) !== null && _agentsSelection$plat !== void 0 && _agentsSelection$plat.length || (_agentsSelection$poli = agentsSelection.policiesSelected) !== null && _agentsSelection$poli !== void 0 && _agentsSelection$poli.length);
    return !isValid ? _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.osqueryAgentsMissingErrorMessage', {
      defaultMessage: 'Agents is a required field'
    }) : undefined;
  }
  return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.osqueryAgentsMissingErrorMessage', {
    defaultMessage: 'Agents is a required field'
  });
};
const AgentsTableFieldComponent = () => {
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'agentSelection',
    rules: {
      validate: checkAgentsLength
    },
    defaultValue: {}
  });
  return /*#__PURE__*/_react.default.createElement(_agents_table.AgentsTable, {
    agentSelection: value,
    onChange: onChange,
    error: error === null || error === void 0 ? void 0 : error.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 10
    }
  });
};
const AgentsTableField = exports.AgentsTableField = /*#__PURE__*/_react.default.memo(AgentsTableFieldComponent);