"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "FieldIcon", {
  enumerable: true,
  get: function () {
    return _reactField.FieldIcon;
  }
});
Object.defineProperty(exports, "KibanaContextProvider", {
  enumerable: true,
  get: function () {
    return _public.KibanaContextProvider;
  }
});
exports.useRouterNavigate = exports.useKibana = exports.isModifiedEvent = exports.isLeftClickEvent = void 0;
Object.defineProperty(exports, "useUiSetting", {
  enumerable: true,
  get: function () {
    return _public.useUiSetting;
  }
});
Object.defineProperty(exports, "useUiSetting$", {
  enumerable: true,
  get: function () {
    return _public.useUiSetting$;
  }
});
Object.defineProperty(exports, "withKibana", {
  enumerable: true,
  get: function () {
    return _public.withKibana;
  }
});
var _reactRouterDom = require("react-router-dom");
var _reactField = require("@kbn/react-field");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTypedKibana = () => (0, _public.useKibana)();
exports.useKibana = useTypedKibana;
const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
exports.isModifiedEvent = isModifiedEvent;
const isLeftClickEvent = event => event.button === 0;
exports.isLeftClickEvent = isLeftClickEvent;
const useRouterNavigate = (to, onClickCallback) => {
  const history = (0, _reactRouterDom.useHistory)();
  return (0, _public.reactRouterNavigate)(history, to, onClickCallback);
};
exports.useRouterNavigate = useRouterNavigate;