"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSelectedAgentsMessage = exports.SELECT_AGENT_LABEL = exports.NO_AGENT_AVAILABLE_TITLE = exports.FAIL_ALL_AGENTS = exports.ERROR_ALL_AGENTS = exports.ATTACHED_QUERY = exports.ALL_AGENTS_LABEL = exports.AGENT_SELECTION_LABEL = exports.AGENT_QUERY = exports.AGENT_POLICY_LABEL = exports.AGENT_PLATFORMS_LABEL = exports.AGENT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSelectedAgentsMessage = numAgents => {
  if (numAgents === 0) {
    return '';
  } else if (numAgents === 1) {
    return _i18n.i18n.translate('xpack.osquery.agents.oneSelectedAgentText', {
      defaultMessage: '{numAgents} agent selected.',
      values: {
        numAgents
      }
    });
  } else {
    return _i18n.i18n.translate('xpack.osquery.agents.mulitpleSelectedAgentsText', {
      defaultMessage: '{numAgents} agents selected.',
      values: {
        numAgents
      }
    });
  }
};
exports.generateSelectedAgentsMessage = generateSelectedAgentsMessage;
const ALL_AGENTS_LABEL = exports.ALL_AGENTS_LABEL = _i18n.i18n.translate('xpack.osquery.agents.allAgentsLabel', {
  defaultMessage: `All agents`
});
const AGENT_PLATFORMS_LABEL = exports.AGENT_PLATFORMS_LABEL = _i18n.i18n.translate('xpack.osquery.agents.platformLabel', {
  defaultMessage: `Platform`
});
const AGENT_POLICY_LABEL = exports.AGENT_POLICY_LABEL = _i18n.i18n.translate('xpack.osquery.agents.policyLabel', {
  defaultMessage: `Policy`
});
const AGENT = exports.AGENT = _i18n.i18n.translate('xpack.osquery.agents.agent', {
  defaultMessage: `Agent`
});
const AGENT_SELECTION_LABEL = exports.AGENT_SELECTION_LABEL = _i18n.i18n.translate('xpack.osquery.agents.selectionLabel', {
  defaultMessage: `Agents`
});
const NO_AGENT_AVAILABLE_TITLE = exports.NO_AGENT_AVAILABLE_TITLE = _i18n.i18n.translate('xpack.osquery.agents.noAgentAvailableTitle', {
  defaultMessage: `No agents available`
});
const AGENT_QUERY = exports.AGENT_QUERY = _i18n.i18n.translate('xpack.osquery.agents.query', {
  defaultMessage: `Query`
});
const SELECT_AGENT_LABEL = exports.SELECT_AGENT_LABEL = _i18n.i18n.translate('xpack.osquery.agents.selectAgentLabel', {
  defaultMessage: `Select agents or groups to query`
});
const ERROR_ALL_AGENTS = exports.ERROR_ALL_AGENTS = _i18n.i18n.translate('xpack.osquery.agents.errorSearchDescription', {
  defaultMessage: `An error has occurred on all agents search`
});
const FAIL_ALL_AGENTS = exports.FAIL_ALL_AGENTS = _i18n.i18n.translate('xpack.osquery.agents.failSearchDescription', {
  defaultMessage: `Failed to fetch agents`
});
const ATTACHED_QUERY = exports.ATTACHED_QUERY = _i18n.i18n.translate('xpack.osquery.agent.attachedQuery', {
  defaultMessage: `attached query` // as in 'User attached query 5 minutes ago'
});