"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESULTS_INDEX = exports.QUERY_TIMEOUT = exports.OSQUERY_LOGS_BASE = exports.OSQUERY_INTEGRATION_NAME = exports.OSQUERY_ACTIONS_INDEX = exports.DEFAULT_PLATFORM = exports.DEFAULT_MAX_TABLE_QUERY_SIZE = exports.CASE_ATTACHMENT_TYPE_ID = exports.BASE_PATH = exports.API_VERSIONS = exports.ACTION_RESPONSES_INDEX = exports.ACTION_RESPONSES_DATA_STREAM_INDEX = exports.ACTIONS_INDEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MAX_TABLE_QUERY_SIZE = exports.DEFAULT_MAX_TABLE_QUERY_SIZE = 10000;
const OSQUERY_INTEGRATION_NAME = exports.OSQUERY_INTEGRATION_NAME = 'osquery_manager';
const BASE_PATH = exports.BASE_PATH = '/app/osquery';
const OSQUERY_LOGS_BASE = exports.OSQUERY_LOGS_BASE = `.logs-${OSQUERY_INTEGRATION_NAME}`;
const ACTIONS_INDEX = exports.ACTIONS_INDEX = `${OSQUERY_LOGS_BASE}.actions`;
const RESULTS_INDEX = exports.RESULTS_INDEX = `${OSQUERY_LOGS_BASE}.results`;
const OSQUERY_ACTIONS_INDEX = exports.OSQUERY_ACTIONS_INDEX = `${ACTIONS_INDEX}-*`;
const ACTION_RESPONSES_INDEX = exports.ACTION_RESPONSES_INDEX = `.logs-${OSQUERY_INTEGRATION_NAME}.action.responses`;
const ACTION_RESPONSES_DATA_STREAM_INDEX = exports.ACTION_RESPONSES_DATA_STREAM_INDEX = `logs-${OSQUERY_INTEGRATION_NAME}.action.responses`;
const DEFAULT_PLATFORM = exports.DEFAULT_PLATFORM = 'linux,windows,darwin';
const CASE_ATTACHMENT_TYPE_ID = exports.CASE_ATTACHMENT_TYPE_ID = 'osquery';
const API_VERSIONS = exports.API_VERSIONS = {
  public: {
    v1: '2023-10-31'
  },
  internal: {
    v1: '1'
  }
};
let QUERY_TIMEOUT = exports.QUERY_TIMEOUT = /*#__PURE__*/function (QUERY_TIMEOUT) {
  QUERY_TIMEOUT[QUERY_TIMEOUT["DEFAULT"] = 60] = "DEFAULT";
  QUERY_TIMEOUT[QUERY_TIMEOUT["MAX"] = 86400] = "MAX";
  return QUERY_TIMEOUT;
}({}); // 24 hours