"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDefaultSpace = exports.getCurrentSpaceId = exports.createSpaceDslFilter = void 0;
var _spacesUtils = require("@kbn/spaces-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isDefaultSpace = space => {
  return !space || space === _spacesUtils.DEFAULT_SPACE_ID;
};
exports.isDefaultSpace = isDefaultSpace;
const getCurrentSpaceId = ({
  spaces,
  request
}) => {
  var _spaces$spacesService;
  return (spaces === null || spaces === void 0 ? void 0 : (_spaces$spacesService = spaces.spacesService) === null || _spaces$spacesService === void 0 ? void 0 : _spaces$spacesService.getSpaceId(request)) || _spacesUtils.DEFAULT_SPACE_ID;
};
exports.getCurrentSpaceId = getCurrentSpaceId;
const createSpaceDslFilter = space => {
  return isDefaultSpace(space) ? {
    bool: {
      should: [{
        term: {
          space
        }
      }, {
        bool: {
          must_not: {
            exists: {
              field: 'space'
            }
          }
        }
      }],
      minimum_should_match: 1
    }
  } : {
    bool: {
      should: [{
        term: {
          space
        }
      }],
      minimum_should_match: 1
    }
  };
};
exports.createSpaceDslFilter = createSpaceDslFilter;