"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCurrentTraceId = void 0;
var _api = require("@opentelemetry/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the current traceId (which can be used to check traces in phoenix.
 *
 * **MUST* be called from within an active trace
 */
const getCurrentTraceId = () => {
  var _trace$getActiveSpan;
  return (_trace$getActiveSpan = _api.trace.getActiveSpan()) === null || _trace$getActiveSpan === void 0 ? void 0 : _trace$getActiveSpan.spanContext().traceId;
};
exports.getCurrentTraceId = getCurrentTraceId;