"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEmptyConversation = exports.createConversationServiceMock = exports.createConversationClientMock = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEmptyConversation = () => {
  return {
    id: 'id',
    title: 'New conversation',
    agent_id: 'agent_id',
    rounds: [],
    updated_at: new Date().toISOString(),
    created_at: new Date().toISOString(),
    user: {
      id: 'unknown',
      username: 'unknown'
    }
  };
};
exports.createEmptyConversation = createEmptyConversation;
const createConversationClientMock = () => {
  return {
    get: jest.fn(),
    exists: jest.fn(),
    create: jest.fn(),
    update: jest.fn(),
    list: jest.fn(),
    delete: jest.fn()
  };
};
exports.createConversationClientMock = createConversationClientMock;
const createConversationServiceMock = () => {
  return {
    getScopedClient: jest.fn().mockImplementation(async () => createConversationClientMock())
  };
};
exports.createConversationServiceMock = createConversationServiceMock;