"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEnabledDefinition = exports.isDisabledDefinition = exports.isBuiltinDefinition = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Descriptor for a tool type.
 */

/**
 * Descriptor for disabled tool types.
 * Can be used to register types which aren't usable, e.g. workflow tools without the plugin being enabled.
 */

/**
 * Specific descriptor for builtin tool types.
 */

const isEnabledDefinition = definition => {
  return !('disabled' in definition) && !('builtin' in definition);
};
exports.isEnabledDefinition = isEnabledDefinition;
const isBuiltinDefinition = definition => {
  return 'builtin' in definition && definition.builtin;
};
exports.isBuiltinDefinition = isBuiltinDefinition;
const isDisabledDefinition = definition => {
  return 'disabled' in definition && definition.disabled;
};
exports.isDisabledDefinition = isDisabledDefinition;