"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerBuiltinTools = void 0;
var _definitions = require("./definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerBuiltinTools = ({
  registry
}) => {
  const tools = [(0, _definitions.searchTool)(), (0, _definitions.getDocumentByIdTool)(), (0, _definitions.executeEsqlTool)(), (0, _definitions.generateEsqlTool)(), (0, _definitions.getIndexMappingsTool)(), (0, _definitions.listIndicesTool)(), (0, _definitions.indexExplorerTool)()];
  tools.forEach(tool => {
    registry.register(tool);
  });
};
exports.registerBuiltinTools = registerBuiltinTools;