"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toInternalDefinition = exports.createPersistedProviderFn = void 0;
var _client = require("./client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPersistedProviderFn = opts => ({
  request,
  space
}) => {
  return createPersistedProvider({
    ...opts,
    request,
    space
  });
};
exports.createPersistedProviderFn = createPersistedProviderFn;
const createPersistedProvider = async ({
  space,
  request,
  security,
  elasticsearch,
  toolsService,
  logger
}) => {
  const client = await (0, _client.createClient)({
    elasticsearch,
    logger,
    request,
    security,
    toolsService,
    space
  });
  return {
    id: 'persisted',
    readonly: false,
    has: agentId => {
      return client.has(agentId);
    },
    get: async agentId => {
      const definition = await client.get(agentId);
      return toInternalDefinition({
        definition
      });
    },
    list: async opts => {
      const definitions = await client.list(opts);
      return definitions.map(definition => toInternalDefinition({
        definition
      }));
    },
    create: async createRequest => {
      const definition = await client.create(createRequest);
      return toInternalDefinition({
        definition
      });
    },
    update: async (agentId, update) => {
      const definition = await client.update(agentId, update);
      return toInternalDefinition({
        definition
      });
    },
    delete: agentId => {
      return client.delete({
        id: agentId
      });
    }
  };
};
const toInternalDefinition = ({
  definition
}) => {
  return {
    ...definition,
    readonly: false
  };
};
exports.toInternalDefinition = toInternalDefinition;