"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBuiltinAgentRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _agents = require("@kbn/onechat-common/agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBuiltinAgentRegistry = () => {
  return new BuiltinAgentRegistryImpl();
};
exports.createBuiltinAgentRegistry = createBuiltinAgentRegistry;
class BuiltinAgentRegistryImpl {
  constructor() {
    (0, _defineProperty2.default)(this, "agents", new Map());
  }
  register(agent) {
    if (this.agents.has(agent.id)) {
      throw new Error(`Agent with id ${agent.id} already registered`);
    }
    const errorMessage = (0, _agents.validateAgentId)({
      agentId: agent.id,
      builtIn: true
    });
    if (errorMessage) {
      throw new Error(`Invalid agent id: "${agent.id}": ${errorMessage}`);
    }
    this.agents.set(agent.id, agent);
  }
  has(toolId) {
    return this.agents.has(toolId);
  }
  get(toolId) {
    return this.agents.get(toolId);
  }
  list() {
    return [...this.agents.values()];
  }
}