"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFeatures = void 0;
var _server = require("@kbn/core/server");
var _features = require("../common/features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFeatures = ({
  features
}) => {
  features.registerKibanaFeature({
    id: _features.ONECHAT_FEATURE_ID,
    name: _features.ONECHAT_FEATURE_NAME,
    minimumLicense: 'enterprise',
    order: 1000,
    category: _server.DEFAULT_APP_CATEGORIES.kibana,
    app: ['kibana', _features.ONECHAT_APP_ID],
    catalogue: [_features.ONECHAT_FEATURE_ID],
    privileges: {
      all: {
        app: ['kibana', _features.ONECHAT_APP_ID],
        api: [_features.apiPrivileges.readOnechat, _features.apiPrivileges.manageOnechat],
        catalogue: [_features.ONECHAT_FEATURE_ID],
        savedObject: {
          all: [],
          read: []
        },
        ui: [_features.uiPrivileges.show, _features.uiPrivileges.showManagement, _features.uiPrivileges.manageTools, _features.uiPrivileges.manageAgents]
      },
      read: {
        app: ['kibana', _features.ONECHAT_APP_ID],
        api: [_features.apiPrivileges.readOnechat],
        catalogue: [_features.ONECHAT_FEATURE_ID],
        savedObject: {
          all: [],
          read: []
        },
        ui: [_features.uiPrivileges.show]
      }
    }
  });
};
exports.registerFeatures = registerFeatures;