"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncAgentId = void 0;
var _react = require("react");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _search_param_names = require("../search_param_names");
var _use_agents = require("./agents/use_agents");
var _use_conversation_actions = require("./use_conversation_actions");
var _use_conversation = require("./use_conversation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyncAgentId = () => {
  const {
    agents
  } = (0, _use_agents.useOnechatAgents)();
  const {
    setAgentId
  } = (0, _use_conversation_actions.useConversationActions)();
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const syncedRef = (0, _react.useRef)(false);
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  (0, _react.useEffect)(() => {
    if (syncedRef.current || hasActiveConversation) {
      return;
    }

    // If we don't have a selected agent id, check for a valid agent id in the search params
    // This is used for the "chat with agent" action on the Agent pages
    const agentIdParam = searchParams.get(_search_param_names.searchParamNames.agentId);
    if (agentIdParam && agents.some(agent => agent.id === agentIdParam)) {
      // Agent id passed to sync is valid, set it and mark as synced
      setAgentId(agentIdParam);
      syncedRef.current = true;
    }
  }, [searchParams, setAgentId, agents, hasActiveConversation]);
};
exports.useSyncAgentId = useSyncAgentId;