"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAgentProvider = void 0;
exports.useDeleteAgent = useDeleteAgent;
var _react = _interopRequireWildcard(require("react"));
var _onechatCommon = require("@kbn/onechat-common");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _onechatBrowser = require("@kbn/onechat-browser");
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../hooks/use_kibana");
var _query_keys = require("../query_keys");
var _use_onechat_service = require("../hooks/use_onechat_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/context/delete_agent_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useDeleteAgentMutation({
  onSuccess: handleSuccess,
  onError: handleError
} = {}) {
  const {
    agentService
  } = (0, _use_onechat_service.useOnechatServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const deleteAgentMutation = (0, _reactQuery.useMutation)({
    mutationFn: agentId => {
      if (!agentId) {
        throw new Error('Agent ID is required for delete');
      }
      return agentService.delete(agentId);
    },
    onSuccess: (result, agentId) => {
      // Invalidate specific agent and agent profiles list
      queryClient.removeQueries({
        queryKey: _query_keys.queryKeys.agentProfiles.byId(agentId)
      });
      queryClient.invalidateQueries({
        queryKey: _query_keys.queryKeys.agentProfiles.all
      });
      handleSuccess === null || handleSuccess === void 0 ? void 0 : handleSuccess();
    },
    onError: err => {
      handleError === null || handleError === void 0 ? void 0 : handleError(err);
    }
  });
  return deleteAgentMutation;
}
const AgentDeleteModal = ({
  agent,
  onSuccess: handleSuccess,
  onError: handleError,
  onClose
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'agentDeleteModalTitle'
  });
  const {
    mutate: deleteAgent,
    isLoading: isDeleting
  } = useDeleteAgentMutation({
    onSuccess: () => {
      onClose();
      handleSuccess();
    },
    onError: handleError
  });
  if (!agent) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    role: "alertdialog",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.agents.deleteModal.title",
    defaultMessage: "Delete {name}",
    values: {
      name: agent.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.agents.deleteModal.description",
    defaultMessage: "Are you sure you want to delete this agent? This action cannot be undone.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    isDisabled: isDeleting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.agents.deleteModal.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => {
      deleteAgent(agent.id);
    },
    color: "danger",
    fill: true,
    isLoading: isDeleting,
    "data-test-subj": "onechatAgentDeleteConfirmButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.agents.deleteModal.confirmButton",
    defaultMessage: "Delete",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }))));
};
const DeleteAgentContext = /*#__PURE__*/(0, _react.createContext)(null);
const DeleteAgentProvider = ({
  children,
  onSuccess,
  onError
}) => {
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const handleSuccess = (0, _react.useCallback)(() => {
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.onechat.agents.deleteSuccessMessage', {
      defaultMessage: 'Agent deleted successfully'
    }));
    onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
  }, [onSuccess, notifications]);
  const handleError = (0, _react.useCallback)(error => {
    notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.onechat.agents.deleteErrorMessage', {
        defaultMessage: 'Failed to delete agent'
      }),
      text: (0, _onechatBrowser.formatOnechatErrorMessage)(error)
    });
    onError === null || onError === void 0 ? void 0 : onError(error);
  }, [onError, notifications]);
  const [deletingAgent, setDeletingAgent] = (0, _react.useState)(null);
  const deleteAgentMutation = useDeleteAgentMutation({
    onSuccess: handleSuccess,
    onError: handleError
  });
  return /*#__PURE__*/_react.default.createElement(DeleteAgentContext.Provider, {
    value: {
      deleteAgent: ({
        agent,
        forceWithoutConfirmation = false
      }) => {
        if (agent.id === _onechatCommon.oneChatDefaultAgentId) {
          return;
        }
        if (forceWithoutConfirmation) {
          // I don't think it's likely we'll need to use this, we should always show the modal
          deleteAgentMutation.mutate(agent.id);
        } else {
          setDeletingAgent(agent);
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  }, children, /*#__PURE__*/_react.default.createElement(AgentDeleteModal, {
    agent: deletingAgent,
    onSuccess: handleSuccess,
    onError: handleError,
    onClose: () => {
      setDeletingAgent(null);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }));
};
exports.DeleteAgentProvider = DeleteAgentProvider;
function useDeleteAgent() {
  const context = (0, _react.useContext)(DeleteAgentContext);
  if (!context) {
    throw new Error('useDeleteAgent must be used within a DeleteAgentProvider');
  }
  return context;
}