"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sharedValidationSchemas = exports.sharedI18nMessages = void 0;
var _i18n = require("@kbn/i18n");
var _tools = require("@kbn/onechat-common/tools");
var _namespaces = require("@kbn/onechat-common/base/namespaces");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sharedI18nMessages = exports.sharedI18nMessages = {
  toolId: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.toolId.requiredError', {
      defaultMessage: 'Tool ID is required.'
    }),
    tooLongError: _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.toolId.tooLongError', {
      defaultMessage: 'Tool ID must be 63 characters or less.'
    }),
    formatError: _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.toolId.formatError', {
      defaultMessage: 'Tool ID must start with a letter and contain only lowercase letters, numbers, and hyphens.'
    }),
    reservedError: name => _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.toolId.reservedError', {
      defaultMessage: 'Tool ID "{name}" is reserved.',
      values: {
        name
      }
    }),
    protectedNamespaceError: name => _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.toolId.protectedNamespaceError', {
      defaultMessage: 'Tool ID "{name}" uses a protected namespace.',
      values: {
        name
      }
    })
  },
  description: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.newTool.validation.description.requiredError', {
      defaultMessage: 'Description is required.'
    })
  }
};

// Shared validation schemas for common fields
const sharedValidationSchemas = exports.sharedValidationSchemas = {
  toolId: _zod.z.string().min(1, {
    message: sharedI18nMessages.toolId.requiredError
  }).max(_tools.toolIdMaxLength, {
    message: sharedI18nMessages.toolId.tooLongError
  }).regex(_tools.toolIdRegexp, {
    message: sharedI18nMessages.toolId.formatError
  }).refine(name => !(0, _tools.isReservedToolId)(name), name => ({
    message: sharedI18nMessages.toolId.reservedError(name)
  })).refine(name => !(0, _namespaces.isInProtectedNamespace)(name) && !(0, _namespaces.hasNamespaceName)(name), name => ({
    message: sharedI18nMessages.toolId.protectedNamespaceError(name)
  })),
  description: _zod.z.string().min(1, {
    message: sharedI18nMessages.description.requiredError
  }),
  labels: _zod.z.array(_zod.z.string())
};