"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationInputForm = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _send_message_context = require("../../../context/send_message/send_message_context");
var _use_is_sending_message = require("../../../hooks/use_is_sending_message");
var _conversation_input_text_area = require("./conversation_input_text_area");
var _use_conversation = require("../../../hooks/use_conversation");
var _use_agents = require("../../../hooks/agents/use_agents");
var _use_validate_agent_id = require("../../../hooks/agents/use_validate_agent_id");
var _conversation_input_actions = require("./conversation_input_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/conversation_input_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fullHeightStyles = (0, _react.css)`
  height: 100%;
`;
const ConversationInputForm = ({
  onSubmit
}) => {
  const isSendingMessage = (0, _use_is_sending_message.useIsSendingMessage)();
  const [input, setInput] = (0, _react2.useState)('');
  const {
    sendMessage,
    pendingMessage
  } = (0, _send_message_context.useSendMessage)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isFetched
  } = (0, _use_agents.useOnechatAgents)();
  const agentId = (0, _use_conversation.useAgentId)();
  const validateAgentId = (0, _use_validate_agent_id.useValidateAgentId)();
  const isAgentIdValid = validateAgentId(agentId);
  const shouldDisableTextArea = !isAgentIdValid && isFetched && !!agentId;
  const isSubmitDisabled = !input.trim() || isSendingMessage || !isAgentIdValid;
  const handleSubmit = () => {
    if (isSubmitDisabled) {
      return;
    }
    sendMessage({
      message: input
    });
    setInput('');
    onSubmit === null || onSubmit === void 0 ? void 0 : onSubmit();
  };
  const formContainerStyles = (0, _react.css)`
    ${fullHeightStyles}
    padding: ${euiTheme.size.base};
    box-shadow: none;
    border: ${euiTheme.border.thin};
    border-color: ${euiTheme.colors.borderBasePlain};
    border-radius: ${euiTheme.border.radius.medium};
    &:focus-within {
      border-bottom-color: ${euiTheme.colors.primary};
    }
  `;
  const formContainerDisabledStyles = (0, _react.css)`
    background-color: ${euiTheme.colors.backgroundBaseDisabled};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: [formContainerStyles, shouldDisableTextArea && formContainerDisabledStyles],
    direction: "column",
    gutterSize: "s",
    responsive: false,
    alignItems: "stretch",
    justifyContent: "center",
    "data-test-subj": "agentBuilderConversationInputForm",
    "aria-label": _i18n.i18n.translate('xpack.onechat.conversationInputForm', {
      defaultMessage: 'Message input form'
    }),
    "aria-disabled": shouldDisableTextArea,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_input_text_area.ConversationInputTextArea, {
    input: input,
    setInput: setInput,
    onSubmit: handleSubmit,
    disabled: shouldDisableTextArea,
    agentId: agentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), !shouldDisableTextArea && /*#__PURE__*/_react2.default.createElement(_conversation_input_actions.ConversationInputActions, {
    onSubmit: handleSubmit,
    isSubmitDisabled: isSubmitDisabled,
    resetToPendingMessage: () => {
      if (pendingMessage) {
        setInput(pendingMessage);
      }
    },
    agentId: agentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }));
};
exports.ConversationInputForm = ConversationInputForm;