"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.agentFormSchema = void 0;
var _i18n = require("@kbn/i18n");
var _agents = require("@kbn/onechat-common/agents");
var _namespaces = require("@kbn/onechat-common/base/namespaces");
var _zod = require("@kbn/zod");
var _color = require("../../../utils/color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const agentFormSchema = exports.agentFormSchema = _zod.z.object({
  id: _zod.z.string().min(1, {
    message: _i18n.i18n.translate('xpack.onechat.agents.form.idRequired', {
      defaultMessage: 'Agent ID is required.'
    })
  }).max(_agents.agentIdMaxLength, {
    message: _i18n.i18n.translate('xpack.onechat.agents.form.id.tooLongError', {
      defaultMessage: 'Agent ID must be 63 characters or less.'
    })
  }).regex(_agents.agentIdRegexp, {
    message: _i18n.i18n.translate('xpack.onechat.agents.form.idInvalid', {
      defaultMessage: 'Agent ID must start and end with a letter or number, and can only contain lowercase letters, numbers, hyphens, and underscores.'
    })
  }).refine(name => !(0, _namespaces.isInProtectedNamespace)(name) && !(0, _namespaces.hasNamespaceName)(name), name => ({
    message: _i18n.i18n.translate('xpack.onechat.agents.form.id.protectedNamespaceError', {
      defaultMessage: 'Agent ID "{name}" uses a protected namespace.',
      values: {
        name
      }
    })
  })),
  name: _zod.z.string().min(1, {
    message: _i18n.i18n.translate('xpack.onechat.agents.form.nameRequired', {
      defaultMessage: 'Agent name is required.'
    })
  }),
  description: _zod.z.string().min(1, {
    message: _i18n.i18n.translate('xpack.onechat.agents.form.descriptionRequired', {
      defaultMessage: 'Agent description is required.'
    })
  }),
  labels: _zod.z.array(_zod.z.string()).optional(),
  avatar_color: _zod.z.string().optional().refine(value => {
    if (!value) return true;
    return (0, _color.isValidAgentAvatarColor)(value);
  }, {
    message: _i18n.i18n.translate('xpack.onechat.agents.form.avatarColorInvalidError', {
      defaultMessage: 'Please enter a valid hex color code. This can either be a three or six character hex value.'
    })
  }),
  avatar_symbol: _zod.z.string().max(2, {
    message: _i18n.i18n.translate('xpack.onechat.agents.form.avatarSymbolMaxLengthError', {
      defaultMessage: 'Avatar symbol must be 2 characters or less.'
    })
  }).optional(),
  configuration: _zod.z.object({
    instructions: _zod.z.string().optional(),
    tools: _zod.z.array(_zod.z.object({
      tool_ids: _zod.z.array(_zod.z.string())
    }))
  })
});