"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStatsFromSamples = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createStatsFromSamples = ({
  samples
}) => {
  const stats = new Map();
  samples.forEach(sample => {
    Object.entries(sample.values).forEach(([fieldName, fieldValues]) => {
      if (!stats.has(fieldName)) {
        stats.set(fieldName, {
          filled: 0,
          values: new Map()
        });
      }
      const fieldStats = stats.get(fieldName);
      fieldStats.filled++;
      for (const fieldValue of fieldValues) {
        var _fieldStats$values$ge;
        fieldStats.values.set(fieldValue, ((_fieldStats$values$ge = fieldStats.values.get(fieldValue)) !== null && _fieldStats$values$ge !== void 0 ? _fieldStats$values$ge : 0) + 1);
      }
    });
  });
  const fullStats = [...stats.entries()].map(([fieldPath, fieldValues]) => {
    return {
      fieldPath,
      filledDocCount: fieldValues.filled,
      emptyDocCount: samples.length - fieldValues.filled,
      values: (0, _lodash.orderBy)([...fieldValues.values.entries()].map(([value, count]) => ({
        value,
        count
      })), ['count'], ['desc'])
    };
  });
  return {
    sampleCount: samples.length,
    fieldStats: fullStats.reduce((record, entry) => {
      record[entry.fieldPath] = (0, _lodash.omit)(entry, ['fieldPath']);
      return record;
    }, {})
  };
};
exports.createStatsFromSamples = createStatsFromSamples;