"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsLocatorDefinition = exports.HOSTS_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS_LOCATOR_ID = exports.HOSTS_LOCATOR_ID = 'HOSTS_LOCATOR';
const DEFAULT_HOST_LIMIT = 100;
class HostsLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", HOSTS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      var _params$query, _params$dateRange, _params$filters, _params$panelFilters, _params$limit, _params$preferredSche;
      const paramsWithDefaults = {
        query: (_params$query = params.query) !== null && _params$query !== void 0 ? _params$query : {
          language: 'kuery',
          query: ''
        },
        dateRange: (_params$dateRange = params.dateRange) !== null && _params$dateRange !== void 0 ? _params$dateRange : {
          from: 'now-15m',
          to: 'now'
        },
        filters: (_params$filters = params.filters) !== null && _params$filters !== void 0 ? _params$filters : [],
        panelFilters: (_params$panelFilters = params.panelFilters) !== null && _params$panelFilters !== void 0 ? _params$panelFilters : [],
        limit: (_params$limit = params.limit) !== null && _params$limit !== void 0 ? _params$limit : DEFAULT_HOST_LIMIT,
        preferredSchema: (_params$preferredSche = params.preferredSchema) !== null && _params$preferredSche !== void 0 ? _params$preferredSche : null
      };
      const searchString = _rison.default.encodeUnknown(paramsWithDefaults);
      const tableProperties = _rison.default.encodeUnknown(params.tableProperties);
      return {
        app: 'metrics',
        path: `/hosts?_a=${searchString}&tableProperties=${tableProperties}`,
        state: {}
      };
    });
  }
}
exports.HostsLocatorDefinition = HostsLocatorDefinition;