"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyOverviewLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = _interopRequireDefault(require("query-string"));
var _locators = require("@kbn/deeplinks-observability/locators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DependencyOverviewLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _locators.DEPENDENCY_OVERVIEW_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      rangeFrom,
      rangeTo,
      dependencyName,
      environment
    }) => {
      const params = {
        rangeFrom,
        rangeTo,
        environment,
        dependencyName
      };
      return {
        app: 'apm',
        path: `/dependencies/overview?${_queryString.default.stringify(params)}`,
        state: {}
      };
    });
  }
}
exports.DependencyOverviewLocatorDefinition = DependencyOverviewLocatorDefinition;