"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "WrappedElasticsearchClientError", {
  enumerable: true,
  get: function () {
    return _unwrap_es_response.WrappedElasticsearchClientError;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "createOrUpdateIndex", {
  enumerable: true,
  get: function () {
    return _create_or_update_index.createOrUpdateIndex;
  }
});
Object.defineProperty(exports, "createOrUpdateIndexTemplate", {
  enumerable: true,
  get: function () {
    return _create_or_update_index_template.createOrUpdateIndexTemplate;
  }
});
Object.defineProperty(exports, "existsQuery", {
  enumerable: true,
  get: function () {
    return _queries.existsQuery;
  }
});
Object.defineProperty(exports, "getInspectResponse", {
  enumerable: true,
  get: function () {
    return _get_inspect_response.getInspectResponse;
  }
});
Object.defineProperty(exports, "getParsedFilterQuery", {
  enumerable: true,
  get: function () {
    return _get_parsed_filtered_query.getParsedFilterQuery;
  }
});
Object.defineProperty(exports, "kqlQuery", {
  enumerable: true,
  get: function () {
    return _queries.kqlQuery;
  }
});
Object.defineProperty(exports, "metricsExplorerViewSavedObjectAttributesRT", {
  enumerable: true,
  get: function () {
    return _types.metricsExplorerViewSavedObjectAttributesRT;
  }
});
Object.defineProperty(exports, "metricsExplorerViewSavedObjectRT", {
  enumerable: true,
  get: function () {
    return _types.metricsExplorerViewSavedObjectRT;
  }
});
exports.plugin = void 0;
Object.defineProperty(exports, "rangeQuery", {
  enumerable: true,
  get: function () {
    return _queries.rangeQuery;
  }
});
Object.defineProperty(exports, "termQuery", {
  enumerable: true,
  get: function () {
    return _queries.termQuery;
  }
});
Object.defineProperty(exports, "termsQuery", {
  enumerable: true,
  get: function () {
    return _queries.termsQuery;
  }
});
Object.defineProperty(exports, "uiSettings", {
  enumerable: true,
  get: function () {
    return _ui_settings.uiSettings;
  }
});
Object.defineProperty(exports, "unwrapEsResponse", {
  enumerable: true,
  get: function () {
    return _unwrap_es_response.unwrapEsResponse;
  }
});
Object.defineProperty(exports, "wildcardQuery", {
  enumerable: true,
  get: function () {
    return _queries.wildcardQuery;
  }
});
var _configSchema = require("@kbn/config-schema");
var _annotations = require("../common/annotations");
var _create_or_update_index = require("./utils/create_or_update_index");
var _create_or_update_index_template = require("./utils/create_or_update_index_template");
var _unwrap_es_response = require("../common/utils/unwrap_es_response");
var _queries = require("./utils/queries");
var _get_parsed_filtered_query = require("./utils/get_parsed_filtered_query");
var _get_inspect_response = require("../common/utils/get_inspect_response");
var _types = require("./types");
var _ui_settings = require("./ui_settings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ // TODO: https://github.com/elastic/kibana/issues/110905
const configSchema = _configSchema.schema.object({
  annotations: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    }),
    index: _configSchema.schema.string({
      defaultValue: _annotations.DEFAULT_ANNOTATION_INDEX
    })
  }),
  unsafe: _configSchema.schema.object({
    alertDetails: _configSchema.schema.object({
      metrics: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      logs: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      uptime: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      }),
      observability: _configSchema.schema.object({
        enabled: _configSchema.schema.boolean({
          defaultValue: false
        })
      })
    }),
    thresholdRule: _configSchema.schema.object({
      enabled: (0, _configSchema.offeringBasedSchema)({
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        }),
        traditional: _configSchema.schema.boolean({
          defaultValue: false
        })
      })
    }),
    ruleFormV2: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      })
    })
  }),
  customThresholdRule: _configSchema.schema.object({
    groupByPageSize: _configSchema.schema.number({
      defaultValue: 10_000
    })
  }),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  createO11yGenericFeatureId: _configSchema.schema.boolean({
    defaultValue: false
  }),
  managedOtlpServiceUrl: _configSchema.schema.string({
    defaultValue: ''
  })
});
const config = exports.config = {
  exposeToBrowser: {
    unsafe: true,
    aiAssistant: {
      enabled: true,
      feedback: {
        enabled: true
      }
    },
    managedOtlpServiceUrl: true
  },
  schema: configSchema,
  deprecations: ({
    unused
  }) => [unused('unsafe.thresholdRule.enabled', {
    level: 'warning'
  }), unused('unsafe.alertDetails.logs.enabled', {
    level: 'warning'
  }), unused('unsafe.alertDetails.metrics.enabled', {
    level: 'warning'
  }), unused('unsafe.alertDetails.observability.enabled', {
    level: 'warning'
  })]
};
const plugin = async initContext => {
  const {
    ObservabilityPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ObservabilityPlugin(initContext);
};
exports.plugin = plugin;