"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsFeature = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/logs-shared-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/alerting-plugin/common");
var _infra_saved_objects = require("../saved_objects/infra_saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logsRuleTypes = [_ruleDataUtils.LOG_THRESHOLD_ALERT_TYPE_ID, _ruleDataUtils.ES_QUERY_ID, _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID, _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID];
const getLogsFeature = () => {
  const logsAlertingFeatures = logsRuleTypes.map(ruleTypeId => {
    const consumers = [_ruleDataUtils.AlertConsumers.LOGS, _common.ALERTING_FEATURE_ID, ..._ruleDataUtils.DEPRECATED_ALERTING_CONSUMERS];
    return {
      ruleTypeId,
      consumers
    };
  });
  const LOGS_FEATURE = {
    id: _ruleDataUtils.AlertConsumers.LOGS,
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkLogsTitle', {
      defaultMessage: 'Logs'
    }),
    order: 700,
    category: _server.DEFAULT_APP_CATEGORIES.observability,
    app: ['infra', 'logs', 'kibana', 'observability-logs-explorer'],
    catalogue: ['infralogging', 'logs'],
    management: {
      insightsAndAlerting: ['triggersActions']
    },
    alerting: logsAlertingFeatures,
    privileges: {
      all: {
        app: ['infra', 'logs', 'kibana', 'observability-logs-explorer'],
        catalogue: ['infralogging', 'logs'],
        api: ['infra', 'rac'],
        savedObject: {
          all: [_infra_saved_objects.infraSourceConfigurationSavedObjectName, _server2.logViewSavedObjectName],
          read: []
        },
        alerting: {
          rule: {
            all: logsAlertingFeatures
          },
          alert: {
            all: logsAlertingFeatures
          }
        },
        management: {
          insightsAndAlerting: ['triggersActions']
        },
        ui: ['show', 'configureSource', 'save']
      },
      read: {
        app: ['infra', 'logs', 'kibana', 'observability-logs-explorer'],
        catalogue: ['infralogging', 'logs'],
        api: ['infra', 'rac'],
        alerting: {
          rule: {
            read: logsAlertingFeatures
          },
          alert: {
            read: logsAlertingFeatures
          }
        },
        management: {
          insightsAndAlerting: ['triggersActions']
        },
        savedObject: {
          all: [],
          read: [_infra_saved_objects.infraSourceConfigurationSavedObjectName, _server2.logViewSavedObjectName]
        },
        ui: ['show']
      }
    }
  };
  return LOGS_FEATURE;
};
exports.getLogsFeature = getLogsFeature;