"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryClient {
  constructor(analytics) {
    this.analytics = analytics;
  }
  reportRelatedAlertsLoaded(count) {
    this.analytics.reportEvent(_types.TelemetryEventTypes.RELATED_ALERTS_LOADED, {
      count
    });
  }
  reportAlertDetailsPageView(ruleType) {
    this.analytics.reportEvent(_types.TelemetryEventTypes.ALERT_DETAILS_PAGE_VIEW, {
      rule_type: ruleType
    });
  }
  reportAlertAddedToCase(newCaseCreated, from, ruleTypeId) {
    this.analytics.reportEvent(_types.TelemetryEventTypes.ALERT_ADDED_TO_CASE, {
      new_case_created: newCaseCreated,
      from,
      rule_type_id: ruleTypeId
    });
  }
  reportLinkedDashboardViewed(ruleTypeId) {
    this.analytics.reportEvent(_types.TelemetryEventTypes.LINKED_DASHBOARD_VIEW, {
      rule_type_id: ruleTypeId
    });
  }
  reportSuggestedDashboardAdded(ruleTypeId) {
    this.analytics.reportEvent(_types.TelemetryEventTypes.SUGGESTED_DASHBOARD_ADDED, {
      rule_type_id: ruleTypeId
    });
  }
}
exports.TelemetryClient = TelemetryClient;