"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPage = AlertsPage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _maintenance_window_callout = require("@kbn/alerts-ui-shared/src/maintenance_window_callout");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _alertsGrouping = require("@kbn/alerts-grouping");
var _common = require("../../../common");
var _render_group_panel = require("../../components/alerts_table/grouping/render_group_panel");
var _get_group_stats = require("../../components/alerts_table/grouping/get_group_stats");
var _get_aggregations_by_grouping_field = require("../../components/alerts_table/grouping/get_aggregations_by_grouping_field");
var _constants = require("../../components/alerts_table/grouping/constants");
var _alert_search_bar = require("../../components/alert_search_bar/alert_search_bar");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_time_buckets = require("../../hooks/use_time_buckets");
var _use_toast = require("../../hooks/use_toast");
var _kibana_react = require("../../utils/kibana_react");
var _containers = require("../../components/alert_search_bar/containers");
var _calculate_bucket_size = require("../overview/helpers/calculate_bucket_size");
var _alert_summary_widget = require("../../utils/alert_summary_widget");
var _constants2 = require("../../../common/constants");
var _constants3 = require("../../constants");
var _use_get_available_rules_with_descriptions = require("../../hooks/use_get_available_rules_with_descriptions");
var _alerts_table = require("../../components/alerts_table/alerts_table");
var _get_columns = require("../../components/alerts_table/common/get_columns");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _build_es_query = require("../../utils/build_es_query");
var _rule_stats = require("./components/rule_stats");
var _merge_bool_queries = require("./helpers/merge_bool_queries");
var _grouping_toolbar_controls = require("../../components/alerts_table/grouping/grouping_toolbar_controls");
var _alerts_loader = require("./components/alerts_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alerts/alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERTS_SEARCH_BAR_ID = 'alerts-search-bar-o11y';
const ALERTS_PER_PAGE = 50;
const ALERTS_TABLE_ID = 'xpack.observability.alerts.alert.table';
const DEFAULT_INTERVAL = '60s';
const DEFAULT_DATE_FORMAT = 'YYYY-MM-DD HH:mm';
const DEFAULT_EMPTY_FILTERS = [];
const tableColumns = (0, _get_columns.getColumns)({
  showRuleName: true
});
function InternalAlertsPage() {
  var _alertSearchBarStateP2;
  const kibanaServices = (0, _kibana_react.useKibana)().services;
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    cases,
    settings,
    charts,
    dataViews,
    observabilityAIAssistant,
    share: {
      url: {
        locators
      }
    },
    spaces,
    triggersActionsUi: {
      getAlertsSearchBar: AlertsSearchBar,
      getAlertSummaryWidget: AlertSummaryWidget
    },
    uiSettings
  } = kibanaServices;
  const {
    toasts
  } = notifications;
  const {
    query: {
      timefilter: {
        timefilter: timeFilterService
      }
    }
  } = data;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const [filterControls, setFilterControls] = (0, _react.useState)();
  const [controlApi, setControlApi] = (0, _react.useState)();
  const alertSearchBarStateProps = (0, _containers.useAlertSearchBarStateContainer)(_constants2.ALERTS_URL_STORAGE_KEY, {
    replace: false
  });
  const hasInitialControlLoadingFinished = (0, _react.useMemo)(() => controlApi && Array.isArray(filterControls), [controlApi, filterControls]);
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const themeOverrides = charts.theme.useChartsBaseTheme();
  const globalFilters = (0, _react.useMemo)(() => {
    var _alertSearchBarStateP;
    return [...((_alertSearchBarStateP = alertSearchBarStateProps.filters) !== null && _alertSearchBarStateP !== void 0 ? _alertSearchBarStateP : DEFAULT_EMPTY_FILTERS), ...(filterControls !== null && filterControls !== void 0 ? filterControls : DEFAULT_EMPTY_FILTERS)];
  }, [alertSearchBarStateProps.filters, filterControls]);
  const globalQuery = (0, _react.useMemo)(() => {
    return {
      query: alertSearchBarStateProps.kuery,
      language: 'kuery'
    };
  }, [alertSearchBarStateProps.kuery]);
  const {
    setScreenContext
  } = (observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service) || {};
  const ruleTypesWithDescriptions = (0, _use_get_available_rules_with_descriptions.useGetAvailableRulesWithDescriptions)();
  const [tableLoading, setTableLoading] = (0, _react.useState)(true);
  const [tableCount, setTableCount] = (0, _react.useState)(0);
  const onUpdate = ({
    isLoading,
    alertsCount
  }) => {
    setTableLoading(isLoading);
    setTableCount(alertsCount);
  };
  (0, _ebtTools.usePageReady)({
    isRefreshing: tableLoading,
    isReady: !tableLoading,
    customMetrics: {
      key1: 'total_alert_count',
      value1: tableCount
    },
    meta: {
      rangeFrom: alertSearchBarStateProps.rangeFrom,
      rangeTo: alertSearchBarStateProps.rangeTo,
      description: '[ttfmp_alerts] The Observability Alerts page has loaded a table of alerts.'
    }
  });
  const onGroupingsChange = (0, _react.useCallback)(({
    activeGroups
  }) => {
    alertSearchBarStateProps.onGroupingsChange(activeGroups);
  }, [alertSearchBarStateProps]);
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      data: ruleTypesWithDescriptions.map(rule => ({
        name: rule.id,
        value: `${rule.name} ${rule.description}`,
        description: `An available rule is ${rule.name}.`
      })),
      starterPrompts: [{
        title: _i18n.i18n.translate('xpack.observability.app.starterPrompts.explainRules.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.observability.app.starterPrompts.explainRules.prompt', {
          defaultMessage: `Can you explain the rule types that are available?`
        }),
        icon: 'sparkles'
      }]
    });
  }, [filteredRuleTypes, ruleTypesWithDescriptions, setScreenContext]);
  const onBrushEnd = brushEvent => {
    const {
      x
    } = brushEvent;
    if (x) {
      const [start, end] = x;
      alertSearchBarStateProps.onRangeFromChange(new Date(start).toISOString());
      alertSearchBarStateProps.onRangeToChange(new Date(end).toISOString());
    }
  };
  const [ruleStatsLoading, setRuleStatsLoading] = (0, _react.useState)(false);
  const [ruleStats, setRuleStats] = (0, _react.useState)({
    total: 0,
    disabled: 0,
    muted: 0,
    error: 0,
    snoozed: 0
  });
  const [esQuery, setEsQuery] = (0, _react.useState)();
  const timeBuckets = (0, _use_time_buckets.useTimeBuckets)();
  const bucketSize = (0, _react.useMemo)(() => (0, _calculate_bucket_size.calculateTimeRangeBucketSize)({
    from: alertSearchBarStateProps.rangeFrom,
    to: alertSearchBarStateProps.rangeTo
  }, timeBuckets), [alertSearchBarStateProps.rangeFrom, alertSearchBarStateProps.rangeTo, timeBuckets]);
  const alertSummaryTimeRange = (0, _react.useMemo)(() => (0, _alert_summary_widget.getAlertSummaryTimeRange)({
    from: alertSearchBarStateProps.rangeFrom,
    to: alertSearchBarStateProps.rangeTo
  }, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) || DEFAULT_INTERVAL, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) || DEFAULT_DATE_FORMAT),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [alertSearchBarStateProps.rangeFrom, alertSearchBarStateProps.rangeTo, bucketSize, esQuery]);
  (0, _public2.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    })
  }], {
    classicOnly: true
  });
  async function loadRuleStats() {
    setRuleStatsLoading(true);
    try {
      const response = await (0, _public.loadRuleAggregations)({
        http,
        ruleTypeIds: filteredRuleTypes,
        consumers: _constants2.observabilityAlertFeatureIds
      });
      const {
        ruleExecutionStatus,
        ruleMutedStatus,
        ruleEnabledStatus,
        ruleSnoozedStatus
      } = response;
      if (ruleExecutionStatus && ruleMutedStatus && ruleEnabledStatus && ruleSnoozedStatus) {
        const total = Object.values(ruleExecutionStatus).reduce((acc, value) => acc + value, 0);
        const {
          disabled
        } = ruleEnabledStatus;
        const {
          muted
        } = ruleMutedStatus;
        const {
          error
        } = ruleExecutionStatus;
        const {
          snoozed
        } = ruleSnoozedStatus;
        setRuleStats({
          ...ruleStats,
          total,
          disabled,
          muted,
          error,
          snoozed
        });
      }
      setRuleStatsLoading(false);
    } catch (_e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.loadError', {
          defaultMessage: 'Unable to load rule stats'
        })
      });
      setRuleStatsLoading(false);
    }
  }
  (0, _react.useEffect)(() => {
    loadRuleStats();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const manageRulesHref = http.basePath.prepend('/app/observability/alerts/rules');
  return /*#__PURE__*/_react.default.createElement(_containers.Provider, {
    value: _containers.alertSearchBarStateContainer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "alertsPageWithData",
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.alertsTitle', {
        defaultMessage: 'Alerts'
      }), " "),
      rightSideItems: (0, _rule_stats.renderRuleStats)(ruleStats, manageRulesHref, ruleStatsLoading, locators.get(_common.rulesLocatorID))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_maintenance_window_callout.MaintenanceWindowCallout, {
    kibanaServices: kibanaServices,
    categories: [_coreApplicationCommon.DEFAULT_APP_CATEGORIES.observability.id],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_search_bar.ObservabilityAlertSearchBar, (0, _extends2.default)({}, alertSearchBarStateProps, {
    appName: ALERTS_SEARCH_BAR_ID,
    onEsQueryChange: setEsQuery,
    filterControls: filterControls,
    onFilterControlsChange: setFilterControls,
    onControlApiAvailable: setControlApi,
    showFilterBar: true,
    services: {
      timeFilterService,
      AlertsSearchBar,
      http,
      data,
      dataViews,
      notifications,
      spaces,
      useToasts: _use_toast.useToasts,
      uiSettings
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 11
    }
  }, hasInitialControlLoadingFinished ? /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    ruleTypeIds: _constants2.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _constants2.observabilityAlertFeatureIds,
    filter: esQuery,
    fullSize: true,
    timeRange: alertSummaryTimeRange,
    chartProps: {
      themeOverrides,
      onBrushEnd
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_alerts_loader.AlertsLoader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 11
    }
  }, esQuery && hasInitialControlLoadingFinished && /*#__PURE__*/_react.default.createElement(_alertsGrouping.AlertsGrouping, {
    ruleTypeIds: _constants2.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _constants2.observabilityAlertFeatureIds,
    from: alertSearchBarStateProps.rangeFrom,
    to: alertSearchBarStateProps.rangeTo,
    globalFilters: globalFilters,
    globalQuery: globalQuery,
    groupingId: _constants3.ALERTS_PAGE_ALERTS_TABLE_CONFIG_ID,
    defaultGroupingOptions: _constants.DEFAULT_GROUPING_OPTIONS,
    initialGroupings: alertSearchBarStateProps !== null && alertSearchBarStateProps !== void 0 && (_alertSearchBarStateP2 = alertSearchBarStateProps.groupings) !== null && _alertSearchBarStateP2 !== void 0 && _alertSearchBarStateP2.length ? alertSearchBarStateProps.groupings : undefined,
    onGroupingsChange: onGroupingsChange,
    getAggregationsByGroupingField: _get_aggregations_by_grouping_field.getAggregationsByGroupingField,
    renderGroupPanel: _render_group_panel.renderGroupPanel,
    getGroupStats: _get_group_stats.getGroupStats,
    services: {
      notifications,
      dataViews,
      http
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 15
    }
  }, groupingFilters => {
    const groupQuery = (0, _build_es_query.buildEsQuery)({
      filters: groupingFilters
    });
    return /*#__PURE__*/_react.default.createElement(_alerts_table.ObservabilityAlertsTable, {
      id: ALERTS_TABLE_ID,
      ruleTypeIds: _constants2.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
      consumers: _constants2.observabilityAlertFeatureIds,
      query: (0, _merge_bool_queries.mergeBoolQueries)(esQuery, groupQuery),
      pageSize: ALERTS_PER_PAGE,
      onUpdate: onUpdate,
      columns: tableColumns,
      renderAdditionalToolbarControls: () => /*#__PURE__*/_react.default.createElement(_grouping_toolbar_controls.GroupingToolbarControls, {
        groupingId: _constants3.ALERTS_PAGE_ALERTS_TABLE_CONFIG_ID,
        ruleTypeIds: _constants2.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 381,
          columnNumber: 25
        }
      }),
      showInspectButton: true,
      services: {
        data,
        http,
        notifications,
        fieldFormats,
        application,
        licensing,
        cases,
        settings
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 21
      }
    });
  })))));
}
function AlertsPage() {
  return /*#__PURE__*/_react.default.createElement(_containers.Provider, {
    value: _containers.alertSearchBarStateContainer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(InternalAlertsPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 7
    }
  }));
}