"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkUntrackAlerts = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _common = require("@kbn/alerting-plugin/common");
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkUntrackAlerts = () => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const untrackAlerts = (0, _reactQuery.useMutation)(['untrackAlerts'], ({
    indices,
    alertUuids
  }) => {
    try {
      const body = JSON.stringify({
        ...(indices !== null && indices !== void 0 && indices.length ? {
          indices
        } : {}),
        ...(alertUuids ? {
          alert_uuids: alertUuids
        } : {})
      });
      return http.post(`${_common.INTERNAL_BASE_ALERTING_API_PATH}/alerts/_bulk_untrack`, {
        body
      });
    } catch (e) {
      throw new Error(`Unable to parse bulk untrack params: ${e}`);
    }
  }, {
    onError: (_err, params) => {
      toasts.addDanger(_i18n.i18n.translate('xpack.observability.alerts.untrackConfirmation.errorNotification.descriptionText', {
        defaultMessage: 'Failed to untrack {uuidsCount, plural, one {alert} other {alerts}}',
        values: {
          uuidsCount: params.alertUuids.length
        }
      }));
    },
    onSuccess: (_, params) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.alerts.untrackConfirmation.successNotification.descriptionText', {
        defaultMessage: 'Untracked {uuidsCount, plural, one {alert} other {alerts}}',
        values: {
          uuidsCount: params.alertUuids.length
        }
      }));
    }
  });
  return untrackAlerts;
};
exports.useBulkUntrackAlerts = useBulkUntrackAlerts;