"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchRuleTypes = useFetchRuleTypes;
var _reactQuery = require("@kbn/react-query");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchRuleTypes({
  filterByRuleTypeIds
}) {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchRuleTypes', filterByRuleTypeIds],
    queryFn: async ({
      signal
    }) => {
      try {
        const res = await http.get(`${_common.BASE_ALERTING_API_PATH}/rule_types`, {
          signal
        });
        const response = res.map(item => {
          return (0, _lodash.mapKeys)(item, (_, k) => (0, _lodash.camelCase)(k));
        });
        return filterByRuleTypeIds && filterByRuleTypeIds.length > 0 ? response.filter(item => filterByRuleTypeIds.includes(item.id)) : response;
      } catch (error) {
        throw error;
      }
    },
    keepPreviousData: true,
    refetchOnWindowFocus: false,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleTypeLoadError', {
          defaultMessage: 'Unable to load rule type.'
        }),
        toastMessage: error instanceof Error ? error.message : typeof error === 'string' ? error : ''
      });
    }
  });
  return {
    ruleTypes: data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}