"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeRangeRT = exports.metricsExplorerSeriesRT = exports.metricsExplorerRowRT = exports.metricsExplorerResponseRT = exports.metricsExplorerPageInfoRT = exports.metricsExplorerMetricRT = exports.metricsExplorerColumnTypeRT = exports.metricsExplorerColumnRT = exports.expressionTimestampsRT = exports.expressionOptionsRT = exports.afterKeyObjectRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("../../../common/custom_threshold_rule/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expressionTimestampsRT = exports.expressionTimestampsRT = rt.type({
  fromTimestamp: rt.number,
  toTimestamp: rt.number,
  interval: rt.string,
  timeFieldName: rt.string
});
/*
 * Expression options
 */
const metricsExplorerMetricRT = exports.metricsExplorerMetricRT = rt.intersection([rt.type({
  name: rt.string,
  aggregation: _types.aggType
}), rt.partial({
  field: rt.string,
  filter: rt.string
})]);
const customThresholdExpressionMetricRT = rt.intersection([rt.type({
  aggregation: rt.string
}), rt.partial({
  field: rt.union([rt.string, rt.undefined]),
  custom_metrics: rt.array(metricsExplorerMetricRT),
  equation: rt.string
})]);
const expressionOptionsRT = exports.expressionOptionsRT = rt.intersection([rt.type({
  aggregation: rt.string,
  metrics: rt.array(customThresholdExpressionMetricRT)
}), rt.partial({
  limit: rt.number,
  groupBy: rt.union([rt.string, rt.array(rt.string)]),
  filterQuery: rt.string,
  source: rt.string,
  forceInterval: rt.boolean,
  dropLastBucket: rt.boolean
})]);
/*
 * End of expression options
 */

/*
 * Metrics explorer types
 */
const timeRangeRT = exports.timeRangeRT = rt.type({
  from: rt.number,
  to: rt.number,
  interval: rt.string
});
const afterKeyObjectRT = exports.afterKeyObjectRT = rt.record(rt.string, rt.union([rt.string, rt.null]));
const metricsExplorerPageInfoRT = exports.metricsExplorerPageInfoRT = rt.type({
  total: rt.number,
  afterKey: rt.union([rt.string, rt.null, afterKeyObjectRT])
});
const metricsExplorerColumnTypeRT = exports.metricsExplorerColumnTypeRT = rt.keyof({
  date: null,
  number: null,
  string: null
});
const metricsExplorerColumnRT = exports.metricsExplorerColumnRT = rt.type({
  name: rt.string,
  type: metricsExplorerColumnTypeRT
});
const metricsExplorerRowRT = exports.metricsExplorerRowRT = rt.intersection([rt.type({
  timestamp: rt.number
}), rt.record(rt.string, rt.union([rt.string, rt.number, rt.null, rt.undefined, rt.array(rt.object)]))]);
const metricsExplorerSeriesRT = exports.metricsExplorerSeriesRT = rt.intersection([rt.type({
  id: rt.string,
  columns: rt.array(metricsExplorerColumnRT),
  rows: rt.array(metricsExplorerRowRT)
}), rt.partial({
  keys: rt.array(rt.string)
})]);
const metricsExplorerResponseRT = exports.metricsExplorerResponseRT = rt.type({
  series: rt.array(metricsExplorerSeriesRT),
  pageInfo: metricsExplorerPageInfoRT
});

/*
 * End of metrics explorer types
 */