"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloList = useFetchSloList;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloList({
  kqlQuery = '',
  page = 1,
  sortBy = 'status',
  sortDirection = 'desc',
  perPage = 25,
  lastRefresh,
  disabled = false
} = {}) {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['slo', {
      kqlQuery,
      page,
      sortBy,
      sortDirection,
      perPage,
      lastRefresh
    }],
    queryFn: async ({
      signal
    }) => {
      return await http.get(`/api/observability/slos`, {
        query: {
          ...(sortBy && {
            sortBy
          }),
          ...(sortDirection && {
            sortDirection
          }),
          ...(page !== undefined && {
            page
          }),
          ...(perPage !== undefined && {
            perPage
          }),
          hideStale: true
        },
        signal
      });
    },
    enabled: !disabled,
    cacheTime: 0,
    refetchOnWindowFocus: false,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.observability.list.errorNotification', {
          defaultMessage: 'Something went wrong while fetching SLOs'
        })
      });
    }
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}