"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextDecoration = TextDecoration;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/text_decoration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TextDecoration() {
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.textDecoration', {
      defaultMessage: 'Text decoration'
    }),
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "annotation.style.line.textDecoration",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      buttonSize: "compressed",
      isFullWidth: true,
      id: "positionOptions",
      idSelected: field.value,
      onChange: id => {
        field.onChange(id);
      },
      options: textOptions,
      legend: _i18n.i18n.translate('xpack.observability.annotationForm.positionLabel.textDecoration', {
        defaultMessage: 'Text decoration'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 11
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }));
}
const textOptions = [{
  id: 'none',
  label: _i18n.i18n.translate('xpack.observability.annotationForm.decoration.none', {
    defaultMessage: 'None'
  })
}, {
  id: 'name',
  label: _i18n.i18n.translate('xpack.observability.annotationForm.decoration.name', {
    defaultMessage: 'Name'
  })
}];