"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_SELECTOR = exports.SLO_LABEL = void 0;
exports.SloSelector = SloSelector;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _sloSchema = require("@kbn/slo-schema");
var _use_fetch_slo_list = require("../hooks/use_fetch_slo_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/slo_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapSlosToOptions = slos => {
  var _slos$map;
  return (_slos$map = slos === null || slos === void 0 ? void 0 : slos.map(slo => {
    var _slo$name, _slo$name2;
    return {
      label: slo.instanceId !== _sloSchema.ALL_VALUE ? `${(_slo$name = slo.name) !== null && _slo$name !== void 0 ? _slo$name : slo.id} (${slo.instanceId})` : (_slo$name2 = slo.name) !== null && _slo$name2 !== void 0 ? _slo$name2 : slo.id,
      value: `${slo.id}-${slo.instanceId}`
    };
  })) !== null && _slos$map !== void 0 ? _slos$map : [];
};
function SloSelector({
  value,
  onSelected,
  hasError
}) {
  const [options, setOptions] = (0, _react.useState)([]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const query = `${searchValue}*`;
  const {
    isLoading,
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    kqlQuery: `slo.name: (${query}) or slo.instanceId.text: (${query})`,
    perPage: 100
  });
  (0, _react.useEffect)(() => {
    const isLoadedWithData = !isLoading && (sloList === null || sloList === void 0 ? void 0 : sloList.results) !== undefined;
    const opts = isLoadedWithData ? mapSlosToOptions(sloList === null || sloList === void 0 ? void 0 : sloList.results) : [];
    setOptions(opts);
  }, [isLoading, sloList]);
  (0, _react.useEffect)(() => {
    if (value && sloList !== null && sloList !== void 0 && sloList.results.length) {
      const selectedSlos = sloList.results.filter(slo => value.id === slo.id && value.instanceId === slo.instanceId);
      const newOpts = mapSlosToOptions(selectedSlos);
      if ((value === null || value === void 0 ? void 0 : value.id) === _sloSchema.ALL_VALUE) {
        newOpts.unshift(ALL_OPTION);
      }
      setSelectedOptions(newOpts);
    }
  }, [value, sloList]);
  const onChange = opts => {
    const isAllSelected = opts.find(opt => opt.value === _sloSchema.ALL_VALUE);
    const prevIsAllSelected = selectedOptions.find(opt => opt.value === _sloSchema.ALL_VALUE);
    if (isAllSelected && !prevIsAllSelected) {
      setSelectedOptions([ALL_OPTION]);
      onSelected({
        all: true
      });
    } else {
      var _results;
      setSelectedOptions(opts);
      const selectedSlos = opts.length >= 1 ? (_results = sloList.results) === null || _results === void 0 ? void 0 : _results.filter(slo => opts.find(opt => opt.value === `${slo.id}-${slo.instanceId}`)) : [];
      onSelected({
        slo: selectedSlos.map(slo => ({
          id: slo.id,
          instanceId: slo.instanceId
        }))[0]
      });
    }
  };
  const onSearchChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(val => {
    setSearchValue(val);
  }, 300), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    async: true,
    compressed: true,
    "aria-label": SLO_LABEL,
    placeholder: SLO_SELECTOR,
    "data-test-subj": "sloSelector",
    options: [ALL_OPTION, ...options],
    selectedOptions: selectedOptions,
    isLoading: isLoading,
    onChange: onChange,
    fullWidth: true,
    onSearchChange: onSearchChange,
    isInvalid: hasError,
    singleSelection: {
      asPlainText: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  });
}
const ALL_OPTION = {
  label: _i18n.i18n.translate('xpack.observability.sloEmbeddable.config.sloSelector.all', {
    defaultMessage: 'All SLOs'
  }),
  value: _sloSchema.ALL_VALUE
};
const SLO_SELECTOR = exports.SLO_SELECTOR = _i18n.i18n.translate('xpack.observability.sloEmbeddable.config.sloSelector.placeholder', {
  defaultMessage: 'Select a SLO'
});
const SLO_LABEL = exports.SLO_LABEL = _i18n.i18n.translate('xpack.observability.sloEmbeddable.config.sloSelector.ariaLabel', {
  defaultMessage: 'SLO'
});