"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasLogMonitoringPrivileges = hasLogMonitoringPrivileges;
var _privileges = require("./privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function hasLogMonitoringPrivileges(esClient, withAPM = false) {
  const res = await esClient.security.hasPrivileges({
    cluster: [_privileges.MONITOR_CLUSTER, 'manage_own_api_key'],
    index: [withAPM ? _privileges.INDEX_LOGS_METRICS_AND_TRACES : _privileges.INDEX_LOGS_AND_METRICS]
  });
  return res.has_all_requested;
}