"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressCallout = ProgressCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _progress_indicator = require("../shared/progress_indicator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/firehose/progress_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SUPPORTED_SERVICES = ['API Gateway', 'AWS Usage', 'CloudTrail', 'DynamoDB', 'EBS', 'EC2', 'ECS', 'ELB', 'EMR', 'Kinesis Data Stream', 'Lambda', 'MSK', 'NAT Gateway', 'RDS', 'Route53', 'S3', 'SNS', 'SQS', 'VPC', 'VPN'];
function ProgressCallout() {
  return /*#__PURE__*/_react.default.createElement(_progress_indicator.ProgressIndicator, {
    "data-test-subj": "observabilityOnboardingFirehoseProgressCallout",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.waitingForDataTitle', {
      defaultMessage: 'Retrieving data from Amazon Data Firehose'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.progressCallout.strong.allServicesWeCanLabel', {
        defaultMessage: 'All services we can detect'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 17
        }
      }, SUPPORTED_SERVICES.map(service => /*#__PURE__*/_react.default.createElement("li", {
        key: service,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 21
        }
      }, service)), /*#__PURE__*/_react.default.createElement("li", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.observability_onboarding.progressCallout.li.otherLabel', {
        defaultMessage: 'Other (Unsupported logs will be stored in a generic Firehose index).'
      })))),
      position: "top",
      type: "info",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    })),
    isLoading: true,
    css: (0, _react2.css)`
        display: inline-block;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  });
}