"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogChanges = getLogChanges;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLogChanges({
  index,
  filters,
  field,
  client,
  dateHistogram
}) {
  var _response$aggregation, _response$aggregation2;
  const countDocumentsResponse = await client.search('get_log_count', {
    size: 0,
    track_total_hits: true,
    index,
    query: {
      bool: {
        filter: filters
      }
    }
  });
  if (countDocumentsResponse.hits.total.value === 0) {
    return [];
  }
  const probability = Math.min(1, 500_000 / countDocumentsResponse.hits.total.value);
  const response = await client.search('get_log_changes', {
    index,
    size: 0,
    track_total_hits: false,
    query: {
      bool: {
        filter: filters
      }
    },
    aggregations: {
      sampler: {
        random_sampler: {
          probability: probability > 0.5 ? 1 : probability
        },
        aggs: {
          groups: {
            categorize_text: {
              field,
              size: 1000
            },
            aggs: {
              over_time: {
                auto_date_histogram: dateHistogram
              },
              changes: {
                change_point: {
                  buckets_path: 'over_time>_count'
                }
                // elasticsearch@9.0.0 change_point aggregation is missing in the types: https://github.com/elastic/elasticsearch-specification/issues/3671
              }
            }
          }
        }
      }
    }
  });
  return (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.sampler.groups.buckets.map(group => {
    var _changes$bucket;
    const changes = group.changes;
    return {
      key: group.key,
      pattern: group.regex,
      over_time: group.over_time.buckets.map(bucket => ({
        x: new Date(bucket.key).getTime(),
        y: bucket.doc_count
      })),
      changes: changes.type.indeterminable || !((_changes$bucket = changes.bucket) !== null && _changes$bucket !== void 0 && _changes$bucket.key) ? {
        type: 'indeterminable'
      } : {
        time: new Date(changes.bucket.key).toISOString(),
        type: Object.keys(changes.type)[0],
        ...Object.values(changes.type)[0]
      }
    };
  })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
}